/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.common.IPUtils;
import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;

public class ActionRadiusInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int mid = this.getIntParameter("mid", -1);
        int lid = this.getIntParameter("lid", -1);
        this.getAttributes(mid, lid);
        this.getAttributeSet(mid, lid);
        this.getIps(mid, lid);
        this.getRealmOptions(mid, lid);
    }

    protected final void getAttributes(int mid, int lid) throws SQLException {
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        String query = "SELECT pair_name, pair_value, pair_realm FROM radius_pair_" + mid + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        ps.executeQuery();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element row = this.createElement(data, "row");
            row.setAttribute("attribute", rs.getString(1));
            row.setAttribute("value", rs.getString(2));
            row.setAttribute("realm", rs.getString(3));
            row.setAttribute("f0", rs.getString(1));
            row.setAttribute("f1", rs.getString(2));
            row.setAttribute("f2", rs.getString(3));
        }
        rs.close();
        ps.close();
    }

    protected final void getAttributeSet(int mid, int lid) throws SQLException {
        Element table = this.createElement(this.rootNode, "set_table");
        Element data = this.createElement(table, "data");
        String query = "SELECT id, set_id, realm FROM radius_pair_set_" + mid + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        ps.executeQuery();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", rs.getString(1));
            int setId = rs.getInt(2);
            row.setAttribute("setId", String.valueOf(setId));
            row.setAttribute("setTitle", this.moduleSetup.get("attrset." + setId + ".title", null));
            row.setAttribute("realm", rs.getString(3));
        }
        rs.close();
        ps.close();
    }

    protected final void getIps(int mid, int lid) throws SQLException {
        Element table = this.createElement(this.rootNode, "address");
        Element data = this.createElement(table, "data");
        String query = "SELECT id, ip, realm FROM radius_pair_ip_" + mid + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        ps.executeQuery();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", rs.getString(1));
            row.setAttribute("ip", IPUtils.convertLongIpToString(rs.getLong(2)));
            row.setAttribute("realm", rs.getString(3));
        }
        rs.close();
        ps.close();
    }

    protected final void getRealmOptions(int mid, int lid) throws SQLException {
        String query = "SELECT rp_mode, realm_group FROM user_login_" + mid + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            Element realmOptions = this.createElement(this.rootNode, "realmOptions");
            realmOptions.setAttribute("rp_mode", rs.getString(1));
            realmOptions.setAttribute("realm_group", rs.getString(2));
        }
        rs.close();
        ps.close();
    }
}

