/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.BalanceService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceDistributeData;
import ru.bitel.common.Utils;

public class ActionContractBalanceTransfer
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        this.cid = this.getIntParameter("cid", -1);
        Date date = this.getDateParameter("date");
        String distribution = this.getParameter("distribution");
        ArrayList<BalanceDistributeData> paymentDistribution = new ArrayList<BalanceDistributeData>();
        if (Utils.notBlankString(distribution)) {
            for (String pair : Utils.toList(distribution)) {
                String[] tokens = pair.split("\\:");
                if (tokens.length != 2) continue;
                int contractId = Utils.parseInt(tokens[0]);
                BalanceDistributeData data = new BalanceDistributeData();
                data.setAmout(Utils.parseBigDecimal(tokens[1], BigDecimal.ZERO));
                paymentDistribution.add(data);
                data.setContractId(contractId);
            }
        }
        BalanceService balanceService = this.context.getService(BalanceService.class, 0);
        balanceService.contractBalanceTransfer(this.cid, date, paymentDistribution, false);
    }
}

