/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.MailMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionContractCard2
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String file = this.getParameter("type");
        String contentType = this.getParameter("contentType");
        if (this.cid < 0 || Utils.isBlankString(file)) {
            throw new BGIllegalArgumentException();
        }
        try {
            Document doc = XMLUtils.newDocument();
            Element card = doc.createElement("card");
            Element user = this.createElement(card, "user");
            user.setAttribute("id", String.valueOf(this.userId));
            try {
                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                XMLStreamWriter w = factory.createXMLStreamWriter(new DOMResult(card));
                new ContractUtils(this.con).addContractXML(this.cid, w, true);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            doc.appendChild(card);
            String maildest = this.getParameter("maildest");
            if (Utils.notBlankString(maildest)) {
                final ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
                XSLManager.getInstance().transform((Source)new DOMSource(doc), file, FOUtils.renderSAXResult(baos, "application/pdf"));
                MimeMultipart m = new MimeMultipart();
                MimeBodyPart attach = new MimeBodyPart();
                m.addBodyPart((BodyPart)attach);
                DataSource ds = new DataSource(){

                    public String getContentType() {
                        return "application/pdf";
                    }

                    public InputStream getInputStream() throws IOException {
                        return new ByteArrayInputStream(baos.toByteArray());
                    }

                    public String getName() {
                        return "card.pdf";
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }
                };
                attach.setDataHandler(new DataHandler(ds));
                attach.setFileName("card.pdf");
                MailMsg msg = new MailMsg(this.setup);
                msg.sendMessage(maildest, "card.pdf", (Multipart)m);
            } else if (contentType != null && contentType.equals("application/pdf")) {
                XSLManager.getInstance().transform((Source)new DOMSource(doc), file, FOUtils.renderSAXResult((OutputStream)this.response.getOutputStream(), "application/pdf"));
            } else {
                XSLManager.getInstance().transform((Source)new DOMSource(doc), file, this.rootNode);
            }
        }
        catch (BGException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

