/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;

@ActionConType(value=2)
public class ActionFilterContract
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Page page = this.getPage();
        int id = this.getIntParameter("id", -1);
        int del = this.getIntParameter("del", 0);
        int firm = this.getIntParameter("firm", 0);
        int type = this.getIntParameter("type", -1);
        long filter = this.getLongParameter("filter", -1L);
        boolean showSub = this.getIntParameter("show_sub", 1) > 0;
        boolean showClosed = this.getBooleanParameter("show_closed", false);
        String contractMask = this.getParameter("contractMask", null);
        String contractComment = this.getParameter("contractComment", null);
        if (contractMask != null) {
            try {
                Pattern.compile(contractMask);
            }
            catch (PatternSyntaxException ex) {
                throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b");
            }
        }
        if (contractComment != null) {
            try {
                Pattern.compile(contractComment);
            }
            catch (PatternSyntaxException ex) {
                throw new BGMessageException("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b");
            }
        }
        Element contracts = this.createElement(this.rootNode, "contracts");
        StringBuilder sb = new StringBuilder(150);
        StringBuilder where = new StringBuilder("1=1");
        sb.append("SELECT id, concat( title, ' [ ', comment, ' ]' ) FROM contract ");
        PermissionChecker.PermissionEntry pc = PermissionChecker.getUserPermition(this.userId);
        if (pc != null && pc.pairEntry != null) {
            sb.append("LEFT JOIN contract_parameter_type_8 as par ON par.cid=contract.id ");
            where.append(" AND par.pid=? AND par.val=?");
        }
        if (filter > 0L) {
            where.append(" AND gr&?=?");
        }
        if (!showClosed) {
            where.append(" AND (date2 IS NULL OR ?<=date2 ) ");
        }
        if (contractMask != null && contractMask.trim().length() > 0) {
            where.append(" AND UPPER(title) REGEXP ?");
        }
        if (contractComment != null && contractComment.trim().length() > 0) {
            where.append(" AND UPPER(comment) REGEXP ?");
        }
        if (id > 0) {
            where.append(" AND contract.id = ? ");
        }
        if (firm > 0) {
            where.append(" AND pfid=?");
        }
        if (type == 1 || type == 0) {
            where.append(" AND fc=?");
        }
        if (filter == 0L && contractMask == null && contractComment == null && firm == 0 && type == -1) {
            where.append(" AND gr=0");
        }
        ContractDao.addContractGroupFilter(where, this.userId);
        if (del == 0) {
            where.append(" AND del=0");
        }
        if (!showSub) {
            where.append(" AND scid IN ( 0, -1 )");
        }
        if (where.length() > 0) {
            sb.append(" WHERE ");
            sb.append((CharSequence)where);
        }
        sb.append(" ORDER BY title");
        if (page.getPageSize() > 0) {
            sb.append(" LIMIT ?, ?");
        }
        int i = 1;
        PreparedStatement ps = this.conSlave.prepareStatement(sb.toString());
        i = this.setValuesToPs(id, firm, type, filter, showClosed, contractMask, contractComment, pc, i, ps);
        if (page.getPageSize() > 0) {
            ps.setInt(i++, page.getPageFirstRecordNumber());
            ps.setInt(i++, page.getPageSize());
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            this.addListItem((Node)contracts, rs.getString(1), rs.getString(2));
        }
        rs.close();
        ps.close();
        i = 1;
        int records = 1;
        sb = new StringBuilder(50);
        sb.append("SELECT count(*) FROM contract ");
        if (pc != null && pc.pairEntry != null) {
            sb.append("LEFT JOIN contract_parameter_type_8 as par ON par.cid=contract.id ");
        }
        if (where.length() > 0) {
            sb.append(" WHERE ");
            sb.append((CharSequence)where);
        }
        ps = this.conSlave.prepareStatement(sb.toString());
        i = this.setValuesToPs(id, firm, type, filter, showClosed, contractMask, contractComment, pc, i, ps);
        rs = ps.executeQuery();
        while (rs.next()) {
            records = rs.getInt(1);
        }
        rs.close();
        ps.close();
        contracts.setAttribute("allRecord", String.valueOf(records));
        if (page.getPageSize() > 0) {
            page.setRecordCount(records);
            this.setPageAttribute(contracts, page);
        }
    }

    protected int setValuesToPs(int id, int firm, int type, long filter, boolean showClosed, String contractMask, String contractComment, PermissionChecker.PermissionEntry pc, int i, PreparedStatement ps) throws SQLException {
        if (pc != null && pc.pairEntry != null) {
            ps.setInt(i++, pc.pairEntry.pid);
            ps.setInt(i++, pc.pairEntry.cid);
        }
        if (filter > 0L) {
            ps.setLong(i++, filter);
            ps.setLong(i++, filter);
        }
        if (!showClosed) {
            Date date = new Date();
            ps.setDate(i++, TimeUtils.convertDateToSqlDate(date));
        }
        if (contractMask != null && contractMask.trim().length() > 0) {
            ps.setString(i++, contractMask.toUpperCase());
        }
        if (contractComment != null && contractComment.trim().length() > 0) {
            ps.setString(i++, contractComment.toUpperCase());
        }
        if (id > 0) {
            ps.setInt(i++, id);
        }
        if (firm > 0) {
            ps.setInt(i++, firm);
        }
        if (type == 1 || type == 0) {
            ps.setInt(i++, type);
        }
        return i;
    }
}

