/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractParamBeforeChangeEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.common.Utils;

public class ActionUpdateEmailInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int pid = this.getIntParameter("pid", -1);
        if (pid < 0 || this.cid < 0) {
            throw new BGIllegalArgumentException();
        }
        String buf = this.getParameter("buf");
        String email = this.getParameter("e-mail", "");
        int eid = this.getIntParameter("eid", -1);
        if ((email = this.processEmails(email)).equals("error")) {
            throw new BGMessageException("\u041e\u0434\u0438\u043d \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0432\u0432\u0435\u0434\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e.");
        }
        ContractEmailParamValue value = new ContractEmailParamValue();
        value.setEmailId(eid);
        value.setEmail(email);
        value.setMailSet(Utils.toIntegerSet(buf.toString()));
        ContractParamBeforeChangeEvent checkEvent = new ContractParamBeforeChangeEvent((int)this.userId, this.cid, pid, value);
        checkEvent = EventProcessor.getInstance().request(checkEvent);
        if (Utils.notBlankString(checkEvent.getError())) {
            throw new BGMessageException(checkEvent.getError());
        }
        new ContractParameterManager(this.con).updateEmailParam(this.cid, pid, value, this.userId);
        new CommentPatternManager(this.con).updateContractComment(this.cid);
        this.context.publishAfterCommit(new ContractParamChangedEvent((int)this.userId, this.cid, pid, value));
    }

    private String processEmails(String email) {
        String result = "";
        email = email.replaceAll("\n{2,}", "\n");
        email = email.replace("  ", " ");
        email = email.replaceAll("\\s*\n\\s*", "\n");
        email = email.trim();
        String emailPattern = this.setup.get("email.param.regexp", "");
        if (emailPattern.equals("")) {
            emailPattern = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])";
        }
        Pattern regexp = Pattern.compile(emailPattern, 2);
        StringTokenizer st = new StringTokenizer(email, "\n");
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            Matcher m = regexp.matcher(next);
            if (!m.find()) {
                return "error";
            }
            result = result + next + "\n";
        }
        return result;
    }
}

