/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.ActionResultContentType;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ChangeContractLimitEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractLimitUserLow;
import ru.bitel.bgbilling.kernel.event.events.LimitChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.common.Utils;

public class ActionContractLimit
extends AbstractAction {
    private static final Map<Integer, String> dMap = new HashMap<Integer, String>();

    public void execute() throws BGException {
        if (this.context.getRequest().getParameter("contentType") == null) {
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.jsp);
        }
        GregorianCalendar now = new GregorianCalendar();
        int yy = this.req.getInt("year", now.get(1));
        int mm = this.req.getInt("month", now.get(2) + 1);
        LimitManager limitManager = new LimitManager(this.con);
        this.dataMap.put("moveList", limitManager.getUserLimitMove(this.cid, yy, mm));
        try (ContractDao contractDao = new ContractDao(this.con, -1);){
            Contract contract = (Contract)contractDao.get(this.cid);
            this.dataMap.put("limit", contract.getBalanceLimit());
            ContractLimitParameters contractLimitParameters = limitManager.getContractLimitParameters(this.setup, contract);
            if (contractLimitParameters != null) {
                this.dataMap.put("contractLimitParameters", contractLimitParameters);
            }
        }
        catch (BGMessageException ex) {
            this.dataMap.put("message", ex.getMessage());
        }
        this.dataMap.put("year", yy);
        this.dataMap.put("month", mm);
        this.dataMap.put("dMap", dMap);
        this.dataMap.put("rand", Utils.guid());
    }

    public void lowLimit() throws BGException {
        int days = this.req.getInt("days", 0);
        BigDecimal summ = this.req.getBigDecimal("summ", BigDecimal.ZERO).abs();
        String requestRand = this.req.get("rand");
        String sessionRand = (String)this.context.getRequest().getSession().getAttribute("rand");
        if (Utils.notBlankString(sessionRand) && requestRand.equals(sessionRand)) {
            this.execute();
            return;
        }
        this.context.getRequest().getSession().setAttribute("rand", (Object)requestRand);
        LimitManager limitManager = new LimitManager(this.con);
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            ContractLimitParameters contractLimitParameters;
            Contract contract = (Contract)contractDao.get(this.cid);
            ChangeContractLimitEvent event = new ChangeContractLimitEvent(contract.getId(), -1);
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString(event.getMessage())) {
                throw new BGMessageException(event.getMessage());
            }
            if (!event.isProcessed() && (contractLimitParameters = limitManager.getContractLimitParameters(this.setup, contract)) != null && summ.compareTo(BigDecimal.ZERO) > 0 && days > 0 && contract.getBalanceMode() == 1) {
                if (summ.compareTo(contractLimitParameters.getMinSumm()) < 0 || summ.compareTo(contractLimitParameters.getMaxSumm()) > 0) {
                    throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u043e\u0442 " + Utils.formatBigDecimalSumm(contractLimitParameters.getMinSumm()) + " \u0434\u043e " + Utils.formatBigDecimalSumm(contractLimitParameters.getMaxSumm()));
                }
                if (days < contractLimitParameters.getMinDays() || days > contractLimitParameters.getMaxDays()) {
                    throw new BGMessageException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043d\u0435\u0439 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u043e\u0442 " + Utils.formatBigDecimalSumm(contractLimitParameters.getMinSumm()) + " \u0434\u043e " + Utils.formatBigDecimalSumm(contractLimitParameters.getMaxSumm()));
                }
                if (contract.getBalanceLimit().subtract(summ).compareTo(contractLimitParameters.getMinLimit()) < 0) {
                    throw new BGMessageException("\u041f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430 \u043d\u0438\u0436\u0435 " + Utils.formatBigDecimalSumm(contractLimitParameters.getMinLimit()) + " \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
                }
                limitManager.lowLimit(this.cid, summ, days);
                this.context.publishAfterCommit(new ContractLimitUserLow(this.userId, this.cid, summ, days));
                this.context.publishAfterCommit(new SystemLimitChangedEvent(this.cid, contract.getBalanceLimit()));
                this.context.publishAfterCommit(new LimitChangedEvent(this.cid, contract.getBalanceLimit()));
            }
        }
        catch (BGMessageException ex) {
            this.dataMap.put("message", ex.getMessage());
        }
        this.execute();
    }

    static {
        dMap.put(1, " \u0434\u0435\u043d\u044c");
        dMap.put(2, " \u0434\u043d\u044f");
        dMap.put(3, " \u0434\u043d\u044f");
        dMap.put(4, " \u0434\u043d\u044f");
        dMap.put(5, " \u0434\u043d\u0435\u0439");
        dMap.put(6, " \u0434\u043d\u0435\u0439");
        dMap.put(7, " \u0434\u043d\u0435\u0439");
        dMap.put(8, " \u0434\u043d\u0435\u0439");
        dMap.put(9, " \u0434\u043d\u0435\u0439");
        dMap.put(10, " \u0434\u043d\u0435\u0439");
    }
}

