/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;

public class ContractModuleManager {
    private Connection con;
    private static final String TABLE_NAME = "contract_module";

    public ContractModuleManager(Connection con) {
        this.con = con;
    }

    public List<BGModule> getContractModules(int contractId) throws BGException {
        return ModuleCache.getInstance().getModulesListWithIds(this.getContractModuleSet(contractId));
    }

    public Set<Integer> getContractModuleSet(int contractId) throws BGException {
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            String query = "SELECT mid FROM contract_module WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return result;
    }

    public Map<Integer, Set<Integer>> getContractModuleMap() throws BGException {
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        try {
            String query = "SELECT cid,mid FROM contract_module";
            Statement ps = this.con.createStatement();
            ResultSet rs = ps.executeQuery(query);
            while (rs.next()) {
                int cid = rs.getInt(1);
                int mid = rs.getInt(2);
                HashSet<Integer> s = (HashSet<Integer>)result.get(cid);
                if (s == null) {
                    s = new HashSet<Integer>();
                    result.put(cid, s);
                }
                s.add(mid);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return result;
    }

    public void addContractModule(int contractId, int moduleId) throws BGException {
        try {
            boolean needInsert = false;
            String query = "SELECT COUNT(*) FROM contract_module WHERE cid=? AND mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, moduleId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                needInsert = rs.getInt(1) == 0;
            }
            rs.close();
            ps.close();
            if (needInsert) {
                ps = this.con.prepareStatement("INSERT INTO contract_module SET cid=?, mid=?");
                ps.setInt(1, contractId);
                ps.setInt(2, moduleId);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public void deleteContractModule(int contractId, int moduleId) throws BGException {
        try {
            ContractDeleteEvent event = EventProcessor.getInstance().request(new ContractDeleteEvent(moduleId, 0, contractId, true));
            if (!Utils.isBlankString(event.getError())) {
                throw new BGException(event.getError());
            }
            EventProcessor.getInstance().request(new ContractDeleteEvent(moduleId, 0, contractId, false));
            String query = "DELETE FROM contract_module WHERE cid=? AND mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, moduleId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }
}

