/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext.dhcp;

import bitel.billing.server.ext.dhcp.DHCPPacket;
import bitel.billing.server.ext.dhcp.DHCPProcessor;
import bitel.billing.server.ext.dhcp.DHCPRelayProcessor;
import bitel.billing.server.ext.dhcp.DHCPRequestThread;
import bitel.billing.server.ext.dhcp.DHCPSetup;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public final class DHCPSocketListener
extends Thread {
    private static final Logger log = Logger.getLogger((String)"dhcp");
    private final int port;
    private final DatagramChannel channel;
    private final Selector selector;
    private final ThreadPoolExecutor pool;
    private final int threadCount;
    private final ByteBuffer buffer;
    private final DHCPProcessor processor;
    private String host = null;

    public DHCPSocketListener(DHCPSetup setup, int port, String host, int threadCount, boolean multiThread, Class<? extends DHCPProcessor> processorClass) {
        DHCPProcessor processor;
        ByteBuffer buffer;
        Selector selector;
        DatagramChannel channel;
        this.port = port;
        this.host = host;
        this.threadCount = threadCount;
        try {
            channel = DatagramChannel.open();
            selector = Selector.open();
            buffer = ByteBuffer.allocateDirect(10240);
            Class<DHCPProcessor> clazz = processorClass.asSubclass(DHCPProcessor.class);
            Constructor<DHCPProcessor> c = clazz.getConstructor(DHCPSetup.class, DatagramChannel.class);
            processor = c.newInstance(setup, channel);
            processor.init();
            log.info((Object)"Processor init ok.");
        }
        catch (Exception e) {
            Object channel2 = null;
            Object selector2 = null;
            Object buffer2 = null;
            Object processor2 = null;
            e.printStackTrace();
            throw new RuntimeException("Error init DHCPSocketListener");
        }
        this.channel = channel;
        this.selector = selector;
        this.buffer = buffer;
        this.processor = processor;
        RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    log.warn((Object)"Wating for free Thread..");
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    executor.execute(r);
                }
            }
        };
        this.pool = multiThread ? new ThreadPoolExecutor(0, threadCount, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), rejectedExecutionHandler) : new ThreadPoolExecutor(0, threadCount, 60L, TimeUnit.SECONDS, new SynchronousQueue(), rejectedExecutionHandler){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        this.initSocket();
        String info = "DHCPSocketListener on port=" + port;
        if (host != null) {
            info = info + ", host = " + host;
        }
        info = info + " init ok.";
        log.info((Object)info);
    }

    private void initSocket() {
        try {
            InetSocketAddress localport = null;
            localport = this.host != null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.port);
            this.channel.socket().bind(localport);
            this.channel.socket().setBroadcast(true);
            this.channel.configureBlocking(false);
            this.channel.register(this.selector, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error init DHCPSocketListener on port=" + this.port);
        }
    }

    public void run2() {
        DatagramSocket socket = this.channel.socket();
        byte[] buf = new byte[4096];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        while (true) {
            try {
                while (true) {
                    DatagramPacket inPacket = new DatagramPacket(buf, buf.length);
                    socket.receive(inPacket);
                    bb.position(0);
                    bb.limit(inPacket.getLength());
                    DHCPPacket request = DHCPPacket.getDHCPPacket(bb);
                    if (request == null) continue;
                    DHCPRequestThread thread = new DHCPRequestThread(this.processor, (InetSocketAddress)inPacket.getSocketAddress(), request);
                    this.pool.execute(thread);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                block4: while (true) {
                    this.selector.select();
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    Iterator<SelectionKey> iter = keys.iterator();
                    while (true) {
                        if (!iter.hasNext()) continue block4;
                        SelectionKey key = iter.next();
                        iter.remove();
                        SelectableChannel c = key.channel();
                        if (!key.isReadable() || c != this.channel) continue;
                        this.buffer.clear();
                        SocketAddress clientAddress = this.channel.receive(this.buffer);
                        if (clientAddress == null) continue;
                        this.buffer.flip();
                        DHCPPacket request = DHCPPacket.getDHCPPacket(this.buffer);
                        if (request == null) continue;
                        DHCPRequestThread thread = new DHCPRequestThread(this.processor, (InetSocketAddress)clientAddress, request);
                        this.pool.execute(thread);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        DHCPSocketListener l = new DHCPSocketListener(null, 3535, null, 100, false, DHCPRelayProcessor.class);
        l.start();
        try {
            DatagramSocket s = new DatagramSocket();
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
            new Timer().scheduleAtFixedRate((TimerTask)new TTimerTask(s), 3000L, 50L);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public final DHCPProcessor getProcessor() {
        return this.processor;
    }

    static class TTimerTask
    extends TimerTask {
        DatagramSocket s;

        public TTimerTask(DatagramSocket s) {
            this.s = s;
        }

        @Override
        public void run() {
            String mess = "010106010303030300000000000000000a000064000000000a5a5a5a001485c0ca3100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000638253633501023604c0a8b86133040000a8c00104ff0000000204ffffb9b003040a5a5a5a0f0f6f66666963652e626974656c2e727506040a000002521201060004000100030208000600179a045bf0ff";
            byte[] b2 = new BigInteger("01010601cd0b5774000000000000000000000000000000000a5a5a5a001485c0ca31000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006382536335010332040a000064370a011c02030f060c28292a521201060004000100030208000600179a045bf0ff000000000000000000000000000000000000", 16).toByteArray();
            b2 = new BigInteger(mess, 16).toByteArray();
            try {
                this.s.send(new DatagramPacket(b2, b2.length, new InetSocketAddress("localhost", 3535)));
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

