/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.server.installer.InstallationCall;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class AddSchedulerTasks
implements InstallationCall {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean call(Setup setup, File zip, String param) {
        boolean result = false;
        Connection con = setup.getDBConnectionFromPool();
        String query = null;
        PreparedStatement psSelect = null;
        PreparedStatement psInsert = null;
        try {
            query = "SELECT class FROM scheduled_class WHERE class=?";
            psSelect = con.prepareStatement(query);
            query = "INSERT INTO scheduled_class( title, class ) VALUES(?, ?)";
            psInsert = con.prepareStatement(query);
            FileInputStream fis = new FileInputStream(zip);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals(param)) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zis, "UTF-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line, "\t");
                    if (st.countTokens() != 2) continue;
                    String className = st.nextToken();
                    String title = st.nextToken();
                    psSelect.setString(1, className);
                    if (psSelect.executeQuery().next()) {
                        System.out.println("Scheduled class " + className + " already exists!");
                        continue;
                    }
                    psInsert.setString(1, title);
                    psInsert.setString(2, className);
                    if (psInsert.executeUpdate() <= 0) continue;
                    System.out.println("Scheduled class " + className + " inserted into database.");
                }
            }
            fis.close();
        }
        catch (Exception ex) {
            System.err.println("Error in call: " + ex.getMessage());
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }
}

