/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer.action;

import bitel.billing.server.ActionBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ActionGetClientPacket
extends ActionBase {
    @Override
    public void doAction() throws SQLException {
        String name = this.getParameter("module_name");
        if (name != null) {
            File nameJarDir;
            boolean fl = false;
            File clientJarDir = new File("client.jars");
            if (clientJarDir.exists() && (nameJarDir = new File(clientJarDir, name)).exists()) {
                try {
                    HttpServletResponse response = (HttpServletResponse)this.request.getAttribute("response");
                    ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
                    for (String jarName : nameJarDir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && name.endsWith(".jar");
                        }
                    })) {
                        int count;
                        ZipEntry zipEntry = new ZipEntry(jarName);
                        zipEntry.setTime(System.currentTimeMillis());
                        zipOutputStream.putNextEntry(zipEntry);
                        ByteBuffer buffer = ByteBuffer.allocate(1024);
                        FileInputStream fileInputStream = new FileInputStream(new File(nameJarDir, jarName));
                        FileChannel jarFileChannel = fileInputStream.getChannel();
                        while ((count = jarFileChannel.read(buffer)) != -1) {
                            buffer.flip();
                            zipOutputStream.write(buffer.array(), 0, count);
                            buffer.clear();
                        }
                        jarFileChannel.close();
                        fileInputStream.close();
                        zipOutputStream.closeEntry();
                    }
                    zipOutputStream.flush();
                    zipOutputStream.close();
                    fl = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!fl) {
                byte[] data;
                String query = "SELECT client_zip FROM installed_modules WHERE name=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && (data = rs.getBytes(1)) != null) {
                    try {
                        HttpServletResponse response = (HttpServletResponse)this.request.getAttribute("response");
                        ServletOutputStream out = response.getOutputStream();
                        out.write(data);
                        out.flush();
                        out.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                rs.close();
                ps.close();
            }
        }
    }
}

