/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load;

import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class TestLoadAndProcess
extends TaskBase {
    @Override
    public String getDescription() {
        return null;
    }

    public TestLoadAndProcess() {
        this.setup = new Setup("data.data");
    }

    @Override
    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            GregorianCalendar cal = new GregorianCalendar();
            Calendar startMonth = (Calendar)((Calendar)cal).clone();
            startMonth.set(5, 1);
            startMonth.set(11, 0);
            int hourAll = (int)((cal.getTimeInMillis() - startMonth.getTimeInMillis()) / 3600000L);
            ((Calendar)cal).add(11, -1);
            cal.set(12, 0);
            cal.set(14, 0);
            cal.set(9, 0);
            StringBuffer buf = new StringBuffer("hourAll = ");
            buf.append(hourAll);
            buf.append("\n");
            buf.append("\n[source_id] source_title => no load/zero-length/no process\n");
            String query = null;
            Date date = new Date(cal.getTime().getTime());
            Timestamp time = new Timestamp(cal.getTime().getTime());
            SimpleDateFormat yyyymm = new SimpleDateFormat("yyyyMM");
            query = "SELECT * FROM source_data_" + yyyymm.format(cal.getTime()) + " WHERE source_id=? AND dt<=?";
            PreparedStatement psSelectSourceData = con.prepareStatement(query);
            query = "SELECT * FROM source WHERE ( isNull( date1 ) OR date1<=? ) AND ( isNull( date2 ) OR date2>=? )";
            PreparedStatement psSelectSource = con.prepareStatement(query);
            psSelectSource.setDate(1, date);
            psSelectSource.setDate(2, date);
            ResultSet rs = psSelectSource.executeQuery();
            while (rs.next()) {
                int loadHourCount = 0;
                int processHourCount = 0;
                int zeroSizeHourCount = 0;
                int source_id = rs.getInt(1);
                psSelectSourceData.setInt(1, source_id);
                psSelectSourceData.setTimestamp(2, time);
                ResultSet rs1 = psSelectSourceData.executeQuery();
                while (rs1.next()) {
                    int process = rs1.getInt("process");
                    long modTime = rs1.getLong("modtime");
                    if ((process & 2) > 0 || modTime > 0L) {
                        ++loadHourCount;
                        if (rs1.getLong("size") == 0L && (process & 2) == 0) {
                            ++zeroSizeHourCount;
                        }
                    }
                    if ((process & 3) <= 0) continue;
                    ++processHourCount;
                }
                if (loadHourCount >= hourAll && processHourCount >= hourAll) continue;
                buf.append("[");
                buf.append(source_id);
                buf.append("] ");
                buf.append(rs.getString("title"));
                buf.append(" => ");
                buf.append(hourAll - loadHourCount);
                buf.append("/");
                buf.append(zeroSizeHourCount);
                buf.append("/");
                buf.append(hourAll - processHourCount);
                buf.append("\n");
            }
            String email = this.taskSetup.get("email", this.setup.get("mail.to.email", null));
            if (email != null && buf.length() > 60) {
                MailMsg msg = new MailMsg(this.setup);
                msg.sendMessage(email, "TestLoadAndProcess", buf.toString());
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    public static void main(String[] args) {
        TestLoadAndProcess test = new TestLoadAndProcess();
        test.initTask();
        test.executeTask();
    }
}

