/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.calc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ItemZoneTrafficCache
implements Serializable {
    private final ConcurrentMap<Integer, ItemZoneTrafficCacheItem> dataMap = new ConcurrentHashMap<Integer, ItemZoneTrafficCacheItem>(200);
    private final ConcurrentMap<Integer, ItemZoneTrafficCacheItem> dataMapInput = new ConcurrentHashMap<Integer, ItemZoneTrafficCacheItem>(200);
    private final ConcurrentMap<Integer, ItemZoneTrafficCacheItem> dataMapOutput = new ConcurrentHashMap<Integer, ItemZoneTrafficCacheItem>(200);
    Logger logger = null;

    public ItemZoneTrafficCache(Logger logger) {
        this.logger = logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addZoneTraffic(Integer itemId, Integer zoneId, int amount, int type) {
        this.addZoneTraffic(this.dataMap, itemId, zoneId, amount);
        if (type == 2) {
            this.addZoneTraffic(this.dataMapInput, itemId, zoneId, amount);
        } else if (type == 1) {
            this.addZoneTraffic(this.dataMapOutput, itemId, zoneId, amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZoneTraffic(ConcurrentMap<Integer, ItemZoneTrafficCacheItem> map, Integer itemId, Integer zoneId, int amount) {
        ItemZoneTrafficCacheItem newItemMap;
        ItemZoneTrafficCacheItem itemMap = (ItemZoneTrafficCacheItem)map.get(itemId);
        if (itemMap == null && (itemMap = map.putIfAbsent(itemId, newItemMap = new ItemZoneTrafficCacheItem())) == null) {
            itemMap = newItemMap;
        }
        ItemZoneTrafficCacheItem itemZoneTrafficCacheItem = itemMap;
        synchronized (itemZoneTrafficCacheItem) {
            itemMap.add(zoneId, amount);
        }
    }

    public Integer getZoneTraffic(Integer itemId, Integer zoneId, int type) {
        Integer result = null;
        result = type == 2 ? this.getZoneTraffic(this.dataMapInput, itemId, zoneId) : (type == 1 ? this.getZoneTraffic(this.dataMapOutput, itemId, zoneId) : this.getZoneTraffic(this.dataMap, itemId, zoneId));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getZoneTraffic(ConcurrentMap<Integer, ItemZoneTrafficCacheItem> map, Integer itemId, Integer zoneId) {
        ItemZoneTrafficCacheItem itemMap = (ItemZoneTrafficCacheItem)map.get(itemId);
        if (itemMap != null) {
            ItemZoneTrafficCacheItem itemZoneTrafficCacheItem = itemMap;
            synchronized (itemZoneTrafficCacheItem) {
                TrafficAmount trafficAmount = itemMap.zoneMap.get(zoneId);
                if (trafficAmount != null) {
                    return trafficAmount.amount;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryUpdate(Connection con, int moduleId, int itemId, Calendar time, long zoneTrafficCacheTime) {
        ItemZoneTrafficCacheItem itemMap;
        this.logger.debug((Object)("tryUpdateTrafficCache[itemId=>" + itemId + "]..."));
        ItemZoneTrafficCacheItem itemZoneTrafficCacheItem = itemMap = this.getItemMap(this.dataMap, itemId);
        synchronized (itemZoneTrafficCacheItem) {
            if (itemMap.loadTime == 0L || time.getTimeInMillis() - itemMap.loadTime > zoneTrafficCacheTime) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("tryUpdateTrafficCache: time.getTimeInMillis()=" + time.getTimeInMillis() + ",itemMap.loadTime=" + itemMap.loadTime + ",zoneTrafficCacheTime=" + zoneTrafficCacheTime));
                }
                this.load(con, moduleId, itemId, time);
                return;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(itemMap.loadTime);
            if (TimeUtils.monthsDelta(time, calendar) != 0) {
                this.logger.debug((Object)"TimeUtils.monthsDelta( time, calendar ) != 0");
                this.load(con, moduleId, itemId, time);
                return;
            }
            itemMap.loadTime = time.getTimeInMillis();
        }
        this.logger.debug((Object)"ItemZoneTrafficCache:no need update");
    }

    private ItemZoneTrafficCacheItem getItemMap(ConcurrentMap<Integer, ItemZoneTrafficCacheItem> map, int itemId) {
        ItemZoneTrafficCacheItem itemMap = (ItemZoneTrafficCacheItem)map.get(itemId);
        if (itemMap == null) {
            ItemZoneTrafficCacheItem newItemMap = new ItemZoneTrafficCacheItem();
            itemMap = map.putIfAbsent(itemId, newItemMap);
            if (itemMap == null) {
                itemMap = newItemMap;
            }
        }
        return itemMap;
    }

    private void load(Connection con, int moduleId, int loginId, Calendar time) {
        this.logger.debug((Object)"ItemZoneTrafficCache:load...");
        long start = System.currentTimeMillis();
        try {
            ItemZoneTrafficCacheItem itemMap = this.getItemMap(this.dataMap, loginId);
            ItemZoneTrafficCacheItem itemMapInput = this.getItemMap(this.dataMapInput, loginId);
            ItemZoneTrafficCacheItem itemMapOutput = this.getItemMap(this.dataMapOutput, loginId);
            String tableName = ServerUtils.getModuleMonthTableName("log_session", time.getTime(), moduleId);
            if (ServerUtils.tableExists(con, tableName)) {
                String query = "SELECT zone, SUM(round_session_time), type FROM " + tableName + " WHERE lid=? GROUP BY zone, type";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, loginId);
                ResultSet rs = ps.executeQuery();
                itemMap.clear();
                itemMapInput.clear();
                itemMapOutput.clear();
                while (rs.next()) {
                    int zoneId = rs.getInt(1);
                    int amount = rs.getInt(2);
                    int type = rs.getInt(3);
                    itemMap.add(zoneId, amount);
                    if (type == 2) {
                        itemMapInput.add(zoneId, amount);
                        continue;
                    }
                    if (type != 1) continue;
                    itemMapOutput.add(zoneId, amount);
                }
                rs.close();
                ps.close();
                itemMap.loadTime = time.getTimeInMillis();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("ItemZoneTrafficCache:itemMap=>" + itemMap.toString()));
                    this.logger.debug((Object)("ItemZoneTrafficCache:itemMapInput=>" + itemMapInput.toString()));
                    this.logger.debug((Object)("ItemZoneTrafficCache:itemMapOutput=>" + itemMapOutput.toString()));
                    this.logger.debug((Object)"ItemZoneTrafficCache:load...Ok");
                }
            }
            long duration = System.currentTimeMillis() - start;
            this.logger.debug((Object)("ItemZoneTrafficCache:load... " + duration + " ms"));
        }
        catch (Exception e) {
            this.logger.debug((Object)"ItemZoneTrafficCache:load...ERROR");
            e.printStackTrace();
        }
    }

    class ItemZoneTrafficCacheItem {
        long loadTime;
        final Map<Integer, TrafficAmount> zoneMap = new HashMap<Integer, TrafficAmount>(4);

        ItemZoneTrafficCacheItem() {
        }

        public void add(Integer zoneId, int amount) {
            TrafficAmount trafficAmount = this.zoneMap.get(zoneId);
            if (trafficAmount == null) {
                this.zoneMap.put(zoneId, new TrafficAmount(amount));
            } else {
                trafficAmount.amount += amount;
            }
        }

        public String toString() {
            if (ItemZoneTrafficCache.this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("loadTime" + this.loadTime);
                for (Integer key : this.zoneMap.keySet()) {
                    sb.append(", " + key + "=>" + this.zoneMap.get((Object)key).amount);
                }
                return sb.toString();
            }
            return super.toString();
        }

        public void clear() {
            this.zoneMap.clear();
        }
    }

    class TrafficAmount {
        int amount;

        public TrafficAmount(int amount) {
            this.amount = amount;
        }
    }
}

