/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.task;

import bitel.billing.server.task.bean.RunTask;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class TaskBaseRunner
extends RunTask {
    private int taskId = 0;
    private Date dt = null;
    private String className = null;
    private String params = null;
    private String moduleId;

    public TaskBaseRunner(String className, Date dt, int taskId, String params, String moduleId) throws Exception {
        this.taskId = taskId;
        this.dt = dt;
        this.className = className;
        this.params = params;
        this.moduleId = moduleId;
        if (this.className == null || this.params == null || this.dt == null) {
            throw new Exception("error param");
        }
    }

    @Override
    public String getDescription() {
        try {
            TaskBase task = (TaskBase)Class.forName(this.className).newInstance();
            if (task != null) {
                GregorianCalendar time = new GregorianCalendar();
                time.setTime(this.dt);
                task.setExecutingTime(time);
                task.setModuleId(this.moduleId);
                task.initTask(Setup.getSetup(), this.taskId, this.params);
                return task.getDescription();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void executeTask() {
        try {
            TaskBase task = (TaskBase)Class.forName(this.className).newInstance();
            if (task != null) {
                this.log = Logger.getLogger(Class.forName(this.className));
                GregorianCalendar time = new GregorianCalendar();
                time.setTime(this.dt);
                task.setModuleId(this.moduleId);
                task.setExecutingTime(time);
                task.initTask(this.setup, this.taskId, this.params);
                long start = System.currentTimeMillis();
                this.log.info((Object)("start task id => " + this.taskId + " at time " + TimeUtils.format(this.dt, "dd.MM.yyyy HH")));
                task.startTask();
                long end = System.currentTimeMillis();
                this.log.info((Object)("task time : " + TimeUtils.formatDeltaTime((end - start) / 1000L)));
            } else {
                this.log.error((Object)"task is null");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
    }

    public String toString() {
        return this.className;
    }
}

