/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.terminal;

import bitel.billing.server.util.AbstractSession;
import bitel.billing.server.util.terminal.TerminalManager;
import java.io.InputStream;
import java.io.OutputStream;
import ru.bitel.bgbilling.common.BGException;

public class AbstractTerminalSession
extends AbstractSession {
    protected int socketTimeTimeout = 10000;
    protected String endString = ">";
    protected TerminalManager finder = null;
    protected String regexp = null;
    private long readWait = 100L;
    protected InputStream inputStream = null;
    protected OutputStream outPutStream = null;

    public AbstractTerminalSession(String host, int port) {
        super(host, port);
    }

    @Override
    public String connect() throws Exception {
        this.initConnection();
        this.finder = new TerminalManager(this.inputStream, this.outPutStream);
        this.finder.setTimeout(this.timeout);
        this.finder.setReadWait(this.readWait);
        this.setEndCondition();
        return this.finder.readFromInput();
    }

    public void setReadWait(long readWait) {
        this.readWait = readWait;
        if (this.finder != null) {
            this.finder.setReadWait(readWait);
        }
    }

    protected void initConnection() throws Exception {
    }

    private void setEndCondition() {
        if (this.endString != null) {
            this.finder.setEndString(this.endString);
        } else if (this.regexp != null) {
            this.finder.setRegexp(this.regexp);
        }
    }

    @Override
    public String doCommand(String command) throws Exception {
        this.setEndCondition();
        return this.finder.doCommand(command + "\r");
    }

    public void doCommandAsync(String command) throws Exception {
        this.finder.doCommandAsync(command + "\r");
    }

    public String doCommandWithoutEndSymbol(String command) throws Exception {
        this.setEndCondition();
        return this.finder.doCommand(command);
    }

    @Override
    public void disconnect() throws BGException {
    }

    public String getEndString() {
        return this.endString;
    }

    public void setEndString(String endString) {
        this.regexp = null;
        this.endString = endString;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
        this.endString = null;
        if (this.finder != null) {
            this.finder.setRegexp(regexp);
        }
    }

    @Deprecated
    public void setRegexp(String regexp, int regexpBufferSize) {
        this.setRegexp(regexp);
    }

    public int getSocketTimeTimeout() {
        return this.socketTimeTimeout;
    }

    public void setSocketTimeTimeout(int socketTimeTimeout) {
        this.socketTimeTimeout = socketTimeTimeout;
    }

    @Deprecated
    public int getRegexpBufferSize() {
        return 0;
    }

    @Deprecated
    public void setRegexpBufferSize(int regexpBufferSize) {
    }
}

