/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.news.common.bean;

import java.io.StringReader;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;

public class News
extends IdTitle
implements Comparable<News> {
    private long groups = 0L;
    private Date date = null;
    private String body = null;
    private Document doc = null;
    private String text = null;

    @XmlAttribute
    public long getGroups() {
        return this.groups;
    }

    public void setGroups(long group) {
        this.groups = group;
    }

    @XmlAttribute
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @XmlAttribute
    public String getBody() {
        return this.body;
    }

    public void setBody(String text) {
        this.body = text;
    }

    @XmlAttribute
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @XmlTransient
    public Document getDocument() {
        if (this.doc == null) {
            this.doc = XMLUtils.newDocument();
            Element item = this.doc.createElement("item");
            item.setAttribute("id", String.valueOf(this.id));
            item.setAttribute("date", TimeUtils.format(this.date, "dd.MM.yyyy"));
            item.setAttribute("title", this.title);
            Document newsDoc = XMLUtils.parseDocument(new InputSource(new StringReader(this.body.replaceAll("[\r\n]", " "))), false);
            if (newsDoc != null) {
                Node node = this.doc.importNode(newsDoc.getDocumentElement(), true);
                item.appendChild(node);
            } else {
                StringTokenizer st = new StringTokenizer(this.body, "\r\n");
                while (st.hasMoreTokens()) {
                    Element div = this.doc.createElement("div");
                    div.appendChild(this.doc.createTextNode(st.nextToken()));
                    item.appendChild(div);
                }
            }
            this.doc.appendChild(item);
        }
        return this.doc;
    }

    @Override
    public int compareTo(News news) {
        return this.date.compareTo(news.getDate());
    }

    @Override
    public String toString() {
        return "[ " + TimeUtils.formatDate(this.date) + " ] " + this.title;
    }
}

