/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.api;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.CDATA;
import ru.bitel.bgbilling.kernel.admin.news.common.bean.News;
import ru.bitel.bgbilling.kernel.admin.news.server.bean.NewsManager;
import ru.bitel.bgbilling.kernel.api.WebApiBase;
import ru.bitel.bgbilling.kernel.auth.AuthModes;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameters;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.sql.ConnectionSet;

public class WebApi
extends WebApiBase {
    private static Logger log = Logger.getLogger(WebApi.class);
    @Resource
    private TariffOptionService tariffOptionService;

    public WebApi(HttpServletRequest request) {
        super(request);
    }

    public void login() {
        String login = this.request.getParameter("login");
        String password = this.request.getParameter("password");
        String authModuleId = this.request.getParameter("midAuth");
        HashMap<Integer, List<Integer>> authModes = new HashMap<Integer, List<Integer>>();
        AuthModes.loadConfig(this.setup, 0L, authModes);
        ModuleUser moduleUser = AuthModes.findModuleUserUserByLogin(login, authModuleId, authModes);
        if (moduleUser != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("moduleUser = [" + moduleUser.toString() + "]"));
            }
            if (moduleUser.getPassword().equals(password) || moduleUser.getPassword().equals(Utils.getDigest(password, "utf-8"))) {
                this.dataMap.put("contractId", moduleUser.getContractId());
                this.dataMap.put("contractTitle", moduleUser.getContractTitle());
            } else {
                this.setError(2, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u043e\u043b\u044f");
            }
        } else {
            this.setError(1, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
    }

    public void contractParameters() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            ContractManager contractManager = new ContractManager(con);
            Contract contract = contractManager.getContractById(contractId);
            contractManager.close();
            if (contract != null) {
                Set<Integer> parameterIds = ContractParameters.getContractParameterIdsInGroup(contract.getParamGroup(), con);
                List<ContractParameterPref> paramList = ContractParameters.getContractParameterPrefList(parameterIds, con);
                Map<Integer, String> paramValues = ContractParameters.getContractParameterValue(paramList, contract.getId(), con);
                ArrayList list = new ArrayList();
                for (ContractParameterPref contractParameterPref : paramList) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put("id", String.valueOf(contractParameterPref.getId()));
                    map.put("typeId", String.valueOf(contractParameterPref.getType().getId()));
                    map.put("title", contractParameterPref.getTitle());
                    map.put("read", String.valueOf(contractParameterPref.isRead()));
                    map.put("write", String.valueOf(contractParameterPref.isWrite()));
                    map.put("value", paramValues.get(contractParameterPref.getId()));
                    map.put("alwaysVisible", String.valueOf(contractParameterPref.isAlwaysVisible()));
                    list.add(map);
                }
                this.dataMap.put("contractParameters", list);
            }
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractBalance() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            ConnectionSet connectionSet = ConnectionSet.newInstance(this.setup, true);
            ContractManager contractManager = new ContractManager(connectionSet.getConnection());
            Contract contract = contractManager.getContractById(contractId);
            contractManager.recycle();
            contractManager.close();
            if (contract != null) {
                ConvergenceBalanceManager convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
                ConvergenceBalance convergenceBalance = convergenceBalanceManager.getBalance(connectionSet, contractId, System.currentTimeMillis());
                DecimalFormat decimalFormat = new DecimalFormat(this.setup.get("web.api.contract.balance.format.pattern", "###,###,###,###.00"));
                this.dataMap.put("sum", decimalFormat.format(convergenceBalance.getBalance()));
                this.dataMap.put("currencyTitleMedium", this.setup.get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
            } else {
                this.setError(1, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractPayments() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            int members = Utils.parseInt(this.request.getParameter("members"), 1);
            SearchResult<Payment> searchResult = new SearchResult<Payment>();
            searchResult.setPeriod(Utils.parsePeriod(this.request.getParameter("date1"), this.request.getParameter("date2"), new Period()));
            PaymentDao paymentDao = new PaymentDao(con);
            paymentDao.searchPaymentList(searchResult, contractId, members);
            paymentDao.close();
            this.paymentList(searchResult);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void lastContractPayments() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            int members = Utils.parseInt(this.request.getParameter("members"), 1);
            int lastPayments = Utils.parseInt(this.request.getParameter("lastPayments"), 3);
            SearchResult<Payment> searchResult = new SearchResult<Payment>();
            PaymentDao paymentDao = new PaymentDao(con);
            paymentDao.searchLastPaymentList(searchResult, contractId, members, lastPayments);
            paymentDao.close();
            this.paymentList(searchResult);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractTarifPlans() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            int emid = Utils.parseInt(this.request.getParameter("entityMid"), -1);
            int eid = Utils.parseInt(this.request.getParameter("entityId"), -1);
            ContractTariffDao contractTariffDao = new ContractTariffDao(con);
            List<ContractTariff> contractTariffList = contractTariffDao.list(contractId, new Date(), emid, eid);
            contractTariffDao.close();
            TariffPlanDao tariffPlanDao = new TariffPlanDao(con);
            Map<Integer, TariffPlan> tariffPlanMap = tariffPlanDao.getTariffPlanMap();
            tariffPlanDao.close();
            ArrayList list = new ArrayList();
            for (ContractTariff contractTariff : contractTariffList) {
                Period period = new Period(contractTariff.getPeriod().getDateFrom(), contractTariff.getPeriod().getDateTo());
                TariffPlan tariffPlan = tariffPlanMap.get(contractTariff.getTariffPlanId());
                String contractTariffTitle = tariffPlan == null ? "???" : tariffPlan.getTitleWeb();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("id", String.valueOf(contractTariff.getId()));
                map.put("tariffPlanId", String.valueOf(contractTariff.getTariffPlanId()));
                map.put("title", contractTariffTitle);
                map.put("dateFrom", TimeUtils.formatDate(period.getDateFrom()));
                map.put("dateTo", TimeUtils.formatDate(period.getDateTo()));
                map.put("period", TimeUtils.formatPeriod(period));
                map.put("comment", contractTariff.getComment());
                map.put("pos", String.valueOf(contractTariff.getPosition()));
                list.add(map);
            }
            this.dataMap.put("contractTarifPlans", list);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractTariffOptions() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            Date now = new Date();
            ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(con);
            List<ContractTariffOption> contractTariffOptionList = contractTariffOptionDao.list(contractId, now);
            contractTariffOptionDao.close();
            ArrayList list = new ArrayList();
            DecimalFormat decimalFormat = new DecimalFormat(this.setup.get("web.api.contract.tariff.option.sum.format.pattern", "###,###,###,###.00"));
            for (ContractTariffOption contractTariffOption : contractTariffOptionList) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("id", String.valueOf(contractTariffOption.getId()));
                map.put("timeFrom", TimeUtils.formatDate(contractTariffOption.getTimeFrom()));
                map.put("timeTo", TimeUtils.formatDate(contractTariffOption.getTimeTo()));
                map.put("title", contractTariffOption.getOptionTitle());
                map.put("optionId", String.valueOf(contractTariffOption.getOptionId()));
                map.put("sum", decimalFormat.format(contractTariffOption.getSumma()));
                list.add(map);
            }
            this.dataMap.put("contractTariffOptions", list);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractModules() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            ArrayList list = new ArrayList();
            for (BGModule bgModule : new ContractModuleManager(con).getContractModules(contractId)) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("id", String.valueOf(bgModule.getId()));
                map.put("title", String.valueOf(bgModule.getTitle()));
                list.add(map);
            }
            this.dataMap.put("contractModules", list);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void newsList() throws BGException {
        int contractId = Utils.parseInt(this.request.getParameter("contractId"), 0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            ContractManager contractManager = new ContractManager(con);
            Contract contract = contractManager.getContractById(contractId);
            contractManager.close();
            if (contract != null) {
                ArrayList list = new ArrayList();
                for (News newsItem : NewsManager.getNewsList(this.setup, contract.getGroups())) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("id", String.valueOf(newsItem.getId()));
                    map.put("date", TimeUtils.format(newsItem.getDate(), "dd.MM.yyyy"));
                    map.put("title", new CDATA(newsItem.getTitle()));
                    map.put("body", new CDATA(newsItem.getBody()));
                    list.add(map);
                }
                this.dataMap.put("newsList", list);
            } else {
                this.setError(1, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    protected void paymentList(SearchResult<Payment> searchResult) throws BGException {
        Connection con = this.setup.getDBConnection();
        PaymentTypeDao paymentTypeDao = new PaymentTypeDao(con);
        Map<Integer, PaymentType> paymentTypeMap = paymentTypeDao.getTypeMapByIds(null);
        paymentTypeDao.close();
        DecimalFormat decimalFormat = new DecimalFormat(this.setup.get("web.api.contract.payment.sum.format.pattern", "###,###,###,###.00"));
        ArrayList list = new ArrayList();
        for (Payment payment : searchResult.getList()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("id", String.valueOf(payment.getId()));
            map.put("typeId", String.valueOf(payment.getTypeId()));
            PaymentType paymentType = paymentTypeMap.get(payment.getTypeId());
            map.put("typeTitle", paymentType == null ? "???" : paymentType.getTitle());
            map.put("date", TimeUtils.format(payment.getDate(), "dd.MM.yyyy"));
            map.put("comment", payment.getComment());
            map.put("sum", decimalFormat.format(payment.getSum()));
            list.add(map);
        }
        this.dataMap.put("contractPayments", list);
        this.dataMap.put("totalSum", decimalFormat.format(searchResult.getSum()));
    }
}

