/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.server;

import java.math.BigDecimal;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMapItem;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.GeographicCode;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneTariffContext;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class CostMapTariffTreeNode
extends TariffTreeNode<AbstractPhoneTariffRequest<AbstractPhoneTariffRequest.AbstractPhoneServiceCost>, AbstractPhoneTariffContext, TreeContext, ThreadContext> {
    private static final Logger logger = Logger.getLogger(CostMapTariffTreeNode.class);
    private int costMapId = -1;

    public CostMapTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.costMapId = parameterMap.getInt("costMapId", -1);
    }

    @Override
    public int execute(Long treeNodeId, Long parentTreeNodeId, AbstractPhoneTariffRequest<AbstractPhoneTariffRequest.AbstractPhoneServiceCost> req, TariffTreeNodeHolder holder, AbstractPhoneTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        BigDecimal parentCost = req.costMapCost;
        int result = super.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext);
        req.costMapCost = parentCost;
        return result;
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractPhoneTariffRequest<AbstractPhoneTariffRequest.AbstractPhoneServiceCost> req, AbstractPhoneTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        String phone = req.phoneTo;
        Set<Long> costMapAcceptedSet = req.getAcceptedSet(CostMapTariffTreeNode.class);
        if (Utils.notBlankString(phone) && !costMapAcceptedSet.contains(parentTreeNodeId)) {
            try {
                CostMapItem root = ctx.costMapCache.getTree(this.costMapId);
                if (root != null) {
                    CostMapItem item = (CostMapItem)root.findCode(phone);
                    if (item != null && item.getCost() != null) {
                        req.costMapCost = item.getCost();
                        req.costMapItemId = item.getId();
                        GeographicCode code = ctx.costMapCache.getGeographicCode().findCode(phone, 0, 0);
                        if (code != null && code.getDestinationId() > 0) {
                            req.dest = code.getDestinationId();
                        } else {
                            logger.warn((Object)("Destination from " + phone + " not found."));
                        }
                        costMapAcceptedSet.add(parentTreeNodeId);
                        return 1;
                    }
                } else {
                    req.addError("CostMap with id=" + this.costMapId + " not found!");
                }
            }
            catch (BGException e) {
                req.addError(e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }
}

