/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.channels;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class StreamReadableChannel
implements ReadableByteChannel {
    private final InputStream inputStream;
    protected final ReadableByteChannel readableByteChannel;
    protected boolean reachEOF = false;

    public StreamReadableChannel(ReadableByteChannel readableByteChannel, InputStream inputStream) {
        this.readableByteChannel = readableByteChannel;
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int num;
        assert (dst.hasArray());
        StreamReadableChannel streamReadableChannel = this;
        synchronized (streamReadableChannel) {
            int n;
            int limit = dst.capacity();
            if (this.reachEOF) {
                return -1;
            }
            for (num = 0; num < limit; num += n) {
                n = this.inputStream.read(dst.array(), num, dst.capacity() - num);
                if (n != -1) continue;
                this.reachEOF = true;
                if (num > 0) {
                    return num;
                }
                return -1;
            }
            dst.position(num);
        }
        return num;
    }

    @Override
    public void close() throws IOException {
        this.readableByteChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this.readableByteChannel.isOpen();
    }
}

