/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.channels;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class StreamWritableChannel
implements WritableByteChannel {
    private final OutputStream outputStream;
    protected final WritableByteChannel writableByteChannel;

    public StreamWritableChannel(WritableByteChannel writableByteChannel, OutputStream outputStream) {
        this.writableByteChannel = writableByteChannel;
        this.outputStream = outputStream;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        assert (src.hasArray());
        int limit = src.remaining();
        this.outputStream.write(src.array(), src.arrayOffset() + src.position(), limit);
        return limit;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }

    @Override
    public boolean isOpen() {
        return this.writableByteChannel.isOpen();
    }
}

