/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;

public class ZLIBReadableChannel
implements ReadableByteChannel {
    private static final Logger log = Logger.getLogger(ZLIBReadableChannel.class);
    protected final Inflater inflater;
    protected final ReadableByteChannel readableChannel;
    protected final ByteBuffer byteBuffer;
    protected final int arrayOffset;
    protected boolean reachEOF = false;
    protected long bytesRead;

    public ZLIBReadableChannel(ReadableByteChannel readableChannel, ByteBuffer buffer) {
        this.readableChannel = readableChannel;
        this.byteBuffer = buffer;
        this.inflater = new Inflater();
        this.arrayOffset = this.byteBuffer.arrayOffset();
        this.bytesRead = this.byteBuffer.position();
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        log.debug((Object)"Zlib read...");
        int written = 0;
        while (buffer.hasRemaining()) {
            int inflated = this.inflate(buffer);
            if (inflated == -1) {
                throw new RuntimeException();
            }
            if (inflated == 0) {
                if (this.reachEOF || this.inflater.finished() || this.inflater.needsDictionary()) {
                    if (written > 0) {
                        return written;
                    }
                    log.debug((Object)"End of ZLIB stream");
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                int read = 0;
                while (this.byteBuffer.hasRemaining() && (read = this.readableChannel.read(this.byteBuffer)) >= 0) {
                }
                if (read == -1 && this.byteBuffer.position() == 0) {
                    log.error((Object)("Unexpected end of file (channel) " + this.readableChannel));
                    this.reachEOF = true;
                }
                this.inflater.setInput(this.byteBuffer.array(), 0, this.byteBuffer.position());
                this.byteBuffer.clear();
                continue;
            }
            written += inflated;
        }
        if (written > 0) {
            return written;
        }
        return 0;
    }

    private int inflate(ByteBuffer buffer) throws IOException {
        int written = 0;
        try {
            int position = buffer.position();
            written = this.inflater.inflate(buffer.array(), position, buffer.remaining());
            if (buffer.remaining() == 0) {
                throw new IOException();
            }
            if (written > 0) {
                buffer.position(position + written);
            }
        }
        catch (DataFormatException ex) {
            IOException x = new IOException();
            x.initCause(ex);
            throw x;
        }
        catch (NullPointerException ex) {
            IOException x = new IOException();
            x.initCause(ex);
            throw x;
        }
        return written;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    public static class ZLIBReadableChannelSync
    extends ZLIBReadableChannel {
        public ZLIBReadableChannelSync(ReadableByteChannel readableChannel, ByteBuffer buffer) {
            super(readableChannel, buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer buffer) throws IOException {
            ZLIBReadableChannelSync zLIBReadableChannelSync = this;
            synchronized (zLIBReadableChannelSync) {
                return super.read(buffer);
            }
        }
    }
}

