/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.hourly;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLogWriter;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.WritableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogEntry;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLoggerTracker;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.concurrent.FutureResult;
import ru.bitel.common.model.Idable;

public abstract class HourlyDataLogger<W extends BGDataLogWriter<?>, T extends DataLog<?>, E extends HourlyDataLogEntry<T>> {
    private static final Logger logger = Logger.getLogger(HourlyDataLogger.class);
    protected final ReentrantLock lock = new ReentrantLock();
    protected ParameterMap setup;
    public final long hourPart;
    protected final ConcurrentHashMap<Long, ConcurrentHashMap<Integer, E>> map = new ConcurrentHashMap();
    private final HourlyDataLoggerTracker<E> tracker;
    private long currentHourPart = Long.MIN_VALUE;
    private ConcurrentHashMap<Integer, E> hourEntryMap;
    private final WeakHashMap<E, W> writerMap = new WeakHashMap();

    public HourlyDataLogger(ParameterMap setup, ScheduledExecutorService executor, long defaultHourPart) {
        this.setup = setup;
        this.hourPart = TimeUnit.MINUTES.toMillis(setup.getLong("datalog.hourPart", defaultHourPart > 0L ? defaultHourPart : 20L));
        this.tracker = new HourlyDataLoggerTracker<E>(setup, this.map, executor);
        Shutdown.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                try {
                    HourlyDataLogger.this.flush(null).get();
                }
                catch (InterruptedException e) {
                    logger.error((Object)"InterruptedException", (Throwable)e);
                }
                catch (ExecutionException e) {
                    logger.error((Object)"ExecutionException", (Throwable)e);
                }
            }
        });
    }

    public ConcurrentHashMap<Integer, E> getForHour(Long hour) {
        return this.getForHourPart(hour);
    }

    public ConcurrentHashMap<Integer, E> getForHourPart(Long hour) {
        ConcurrentHashMap newMapEntry;
        ConcurrentHashMap<Integer, Object> mapEntry = this.map.get(hour);
        if (mapEntry == null && (mapEntry = this.map.putIfAbsent(hour, newMapEntry = new ConcurrentHashMap())) == null) {
            mapEntry = newMapEntry;
        }
        return mapEntry;
    }

    public final Long getHourPart(long millis) {
        return millis / this.hourPart * this.hourPart;
    }

    protected abstract E newEntry(ParameterMap var1, Idable var2, Calendar var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public W getWriter(ConcurrentHashMap<Integer, E> mapEntry, WeakHashMap<E, W> writerMap, long hour, Idable source) {
        BGDataLogWriter result;
        HourlyDataLogEntry<Object> e = (HourlyDataLogEntry)mapEntry.get(source.getId());
        if (e == null) {
            this.lock.lock();
            try {
                e = (HourlyDataLogEntry)mapEntry.get(source.getId());
                if (e == null) {
                    logger.debug((Object)"Create log file...");
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTimeInMillis(hour);
                    E newE = this.newEntry(this.setup, source, c);
                    e = (HourlyDataLogEntry)mapEntry.putIfAbsent(source.getId(), newE);
                    if (e == null) {
                        e = newE;
                    } else {
                        ((DataLog)((HourlyDataLogEntry)newE).log).close();
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((result = (BGDataLogWriter)writerMap.get(e)) == null) {
            result = (BGDataLogWriter)((WritableDataLog)e.log).newWriter(null);
            writerMap.put(e, result);
        }
        return (W)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> flushHourPart(Long hourPart) {
        logger.debug((Object)"Flush data...");
        ArrayList list = new ArrayList();
        this.lock.lock();
        try {
            if (hourPart != null) {
                ConcurrentHashMap<Integer, E> mapEntry = this.map.get(hourPart);
                if (mapEntry != null) {
                    list.addAll(mapEntry.values());
                    mapEntry.clear();
                }
            } else {
                for (ConcurrentHashMap concurrentHashMap : this.map.values()) {
                    list.addAll(concurrentHashMap.values());
                    concurrentHashMap.clear();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (list.size() > 0) {
            return this.tracker.scheduleClose(list);
        }
        FutureResult<Boolean> result = new FutureResult<Boolean>();
        result.set(Boolean.TRUE);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> flush(Long hour) {
        logger.debug((Object)"Flush data...");
        ArrayList<E> list = new ArrayList<E>();
        this.lock.lock();
        try {
            if (hour != null) {
                long nextHour = hour + 3600000L;
                while (hour < nextHour) {
                    ConcurrentHashMap<Integer, E> mapEntry = this.map.get(hour);
                    if (mapEntry != null) {
                        list.addAll(mapEntry.values());
                        mapEntry.clear();
                    }
                    hour = hour + this.hourPart;
                }
            } else {
                for (ConcurrentHashMap<Integer, E> mapEntry : this.map.values()) {
                    list.addAll(mapEntry.values());
                    mapEntry.clear();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (list.size() > 0) {
            return this.tracker.scheduleClose(list);
        }
        FutureResult<Boolean> result = new FutureResult<Boolean>();
        result.set(Boolean.TRUE);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        int num = 0;
        for (Map.Entry<Long, ConcurrentHashMap<Integer, E>> e : this.map.entrySet()) {
            num += e.getValue().size();
        }
        sb.append(" [files: " + num + "]");
        return sb.toString();
    }

    public synchronized void writeRecord(Idable agentDevice, int[] positions, ByteBuffer data, long now) {
        Long hourPart = this.getHourPart(now);
        if (hourPart != this.currentHourPart) {
            this.hourEntryMap = this.getForHourPart(hourPart);
            this.currentHourPart = hourPart;
        }
        long hour = now / 3600000L * 3600000L;
        W writer = this.getWriter(this.hourEntryMap, this.writerMap, hour, agentDevice);
        try {
            ((BGDataLogWriter)writer).writeRecord(data, now, positions);
        }
        catch (Exception e) {
            logger.error((Object)"IOException", (Throwable)e);
        }
    }
}

