/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.service;

import bitel.billing.server.admin.bgsecure.bean.Group;
import bitel.billing.server.admin.bgsecure.bean.GroupManager;
import bitel.billing.server.admin.bgsecure.bean.GroupPermitionsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserGroup;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.ListItem;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService")
public class UserGroupServiceImpl
extends AbstractService
implements UserGroupService {
    @Override
    public List<UserGroup> getGroupList(boolean addUsersCount) throws BGException {
        Map<Integer, Integer> groupUsers = null;
        GroupManager groupManager = new GroupManager(this.getConnection());
        if (addUsersCount) {
            groupUsers = groupManager.getGroupUserCount();
        }
        ArrayList<UserGroup> list = new ArrayList<UserGroup>();
        for (ListItem listItem : groupManager.getGroupList()) {
            UserGroup userGroup = new UserGroup(listItem.getId(), listItem.getTitle());
            if (groupUsers != null) {
                Integer users = groupUsers.get(listItem.getId());
                userGroup.setUsers(users != null ? users : 0);
            }
            list.add(userGroup);
        }
        return list;
    }

    @Override
    public int updateGroup(int id, String title, String comment) throws BGIllegalArgumentException {
        if (id < 0 || Utils.isBlankString(title)) {
            throw new BGIllegalArgumentException();
        }
        Group group = new Group();
        group.setId(id);
        group.setTitle(title);
        group.setComment(comment);
        new GroupManager(this.getConnection()).updateGroup(group);
        return group.getId();
    }

    @Override
    public void deleteGroup(int id) throws BGIllegalArgumentException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        new GroupPermitionsManager(this.getConnection()).updateGroupActions(id, null);
        new GroupManager(this.getConnection()).deleteGroup(id);
        this.context.publishAfterCommit(new ModulesChangedEvent(this.context.getUserId()));
    }
}

