/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractNoteDao
extends AbstractIdDao<ContractNote> {
    public ContractNoteDao(Connection con) {
        super(con, 0, "contract_comment");
    }

    @Override
    protected ContractNote getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractNote result = new ContractNote();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setDateTime(rs.getTimestamp("dt"));
        result.setUserId(rs.getInt("uid"));
        result.setTitle(rs.getString("subject"));
        result.setComment(rs.getString("comment"));
        result.setVisible(rs.getBoolean("visibled"));
        return result;
    }

    @Override
    protected void updateImpl(ContractNote note) throws BGException, SQLException {
        PreparedStatement ps;
        if (note.getId() <= 0) {
            String query = "INSERT INTO " + this.tableName + " SET subject=?, comment=?, uid=?, visibled=?, dt=NOW(), cid=?";
            ps = this.con.prepareStatement(query, 1);
            ps.setInt(5, note.getContractId());
        } else {
            String query = "UPDATE " + this.tableName + " SET subject=?, comment=?, uid=?, dt=NOW(), visibled=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(5, note.getId());
        }
        ps.setString(1, note.getTitle());
        ps.setString(2, note.getComment());
        ps.setInt(3, note.getUserId());
        ps.setBoolean(4, note.isVisible());
        ps.executeUpdate();
        if (note.getId() <= 0) {
            note.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<ContractNote> list(int contractId, boolean onlyForCustomer) throws BGException {
        if (onlyForCustomer) {
            return this.list("cid=? AND visibled=true", "dt DESC", contractId);
        }
        return this.list("cid=?", "dt DESC", contractId);
    }
}

