/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.event;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.LocalEvent;

@EventType(timeToLive=604800000L)
@XmlRootElement
public class ConvergenceBalanceEvent
extends LocalEvent {
    private static final long serialVersionUID = 6603668554061330874L;
    protected final boolean balanceExceedsLimit;
    protected final boolean saldoExceedsZero;
    protected final BigDecimal balance;
    protected final BigDecimal limit;

    protected ConvergenceBalanceEvent() {
        this.balanceExceedsLimit = false;
        this.saldoExceedsZero = false;
        this.balance = null;
        this.limit = null;
    }

    public ConvergenceBalanceEvent(int contractId, boolean balanceExceedsLimit, boolean saldoExceedsZero, BigDecimal balance, BigDecimal limit) {
        super(0, contractId, 0);
        assert (balanceExceedsLimit == balance.compareTo(limit) >= 0);
        this.balanceExceedsLimit = balanceExceedsLimit;
        this.saldoExceedsZero = saldoExceedsZero;
        this.balance = balance;
        this.limit = limit;
    }

    @Deprecated
    public boolean isBalanceUnderLimit() {
        return this.balanceExceedsLimit;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public BigDecimal getLimit() {
        return this.limit;
    }

    public boolean isBalanceExceedsLimit() {
        return this.balanceExceedsLimit;
    }

    public boolean isSaldoExceedsZero() {
        return this.saldoExceedsZero;
    }
}

