/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.convert;

import bitel.billing.server.admin.bean.AddressStruct;
import bitel.billing.server.admin.bean.AddressUtils;
import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.tariff.TariffTreeBuilder;
import bitel.billing.server.util.MailMsg;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamItem;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.convert.RemoveThread;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ConvertUtil
implements AutoCloseable {
    private DefaultServerSetup setup;
    private Connection con;
    private ContractRemover remover;
    private BalanceUtils balanceUtils;
    private ContractManager contractManager;
    private ContractTariffDao contractTariffDao;
    private ContractModuleManager contractModuleManager;
    private ContractParameterPrefDao contractParameterPrefDao;
    private ContractParameterManager contractParameterManager;
    private PaymentDao paymentDao;
    private ChargeDao chargeDao;
    private ContractStatusManager contractStatusManager;
    private MailMsg mailmsg;
    private ContractDao contractDao;

    public ConvertUtil(DefaultServerSetup setup, Connection con) throws BGException {
        this.setup = setup;
        this.con = con;
        this.remover = new ContractRemover(setup, con, null);
        this.balanceUtils = new BalanceUtils(con);
        this.contractManager = new ContractManager(con);
        this.contractTariffDao = new ContractTariffDao(con);
        this.contractModuleManager = new ContractModuleManager(con);
        this.contractParameterPrefDao = new ContractParameterPrefDao(con);
        this.contractParameterManager = new ContractParameterManager(con);
        this.paymentDao = new PaymentDao(con);
        this.chargeDao = new ChargeDao(con);
        this.contractStatusManager = new ContractStatusManager(con);
        this.mailmsg = new MailMsg(setup);
        this.contractDao = new ContractDao(con, 0);
    }

    @Override
    public void close() throws Exception {
        this.balanceUtils.close();
        this.contractManager.recycle();
        this.contractTariffDao.close();
        this.contractParameterPrefDao.close();
        this.contractStatusManager.recycle();
        this.remover.close();
        this.contractDao.close();
    }

    public int removeContracts(int group) throws SQLException, BGException {
        return this.removeContracts(Utils.enumToMask(String.valueOf(group)));
    }

    public int removeContracts(long groups) throws SQLException, BGException {
        return this.removeContracts(groups, null);
    }

    public int removeContracts(long groups, String exceptIds) throws SQLException, BGException {
        String query = "SELECT id FROM contract WHERE gr & ? > 0 ";
        if (Utils.notBlankString(exceptIds)) {
            query = query + " AND id NOT IN (" + exceptIds + ")";
        }
        int count = 0;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, groups);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    this.remover.removeContract(cid, false);
                    ++count;
                    if (this.con.getAutoCommit()) continue;
                    this.con.commit();
                }
            }
        }
        return count;
    }

    public void removeCerberCryptGarbage(int mid_cc) throws SQLException, BGException {
        String query = "SELECT uc.id, contract.id FROM user_card_" + mid_cc + " AS uc LEFT JOIN contract ON uc.cid = contract.id WHERE contract.id IS NULL";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        ArrayList<Integer> ucids = new ArrayList<Integer>();
        while (rs.next()) {
            ucids.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        query = "SELECT cp.id, contract.id FROM card_packet_" + mid_cc + " AS cp LEFT JOIN contract ON cp.cid = contract.id WHERE contract.id IS NULL";
        ps = this.con.prepareStatement(query);
        rs = ps.executeQuery();
        ArrayList<Integer> cpids = new ArrayList<Integer>();
        while (rs.next()) {
            cpids.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        if (ucids.size() > 0) {
            System.out.println("remove " + ucids.size() + " garbage user_card_" + mid_cc + "...");
            query = "DELETE FROM user_card_" + mid_cc + " WHERE id IN (" + Utils.toString(ucids) + ")";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        if (cpids.size() > 0) {
            System.out.println("remove " + cpids.size() + " garbage card_packet_" + mid_cc + "...");
            query = "DELETE FROM card_packet_" + mid_cc + " WHERE id IN (" + Utils.toString(cpids) + ")";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
    }

    public Map<String, Integer> getBillingTariffMap() throws SQLException {
        HashMap<String, Integer> tarifMap = new HashMap<String, Integer>();
        String query = "SELECT id, title FROM tariff_plan";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            tarifMap.put(rs.getString(2).toLowerCase(), rs.getInt(1));
        }
        rs.close();
        ps.close();
        return tarifMap;
    }

    public Map<Integer, Map<String, Map<String, Object>>> getBillingStreetMap() throws SQLException {
        HashMap<Integer, Map<String, Map<String, Object>>> result = new HashMap<Integer, Map<String, Map<String, Object>>>();
        String query = "SELECT id, title, cityid FROM address_street";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            HashMap<String, Object> map;
            int cityId = rs.getInt("cityid");
            String title = rs.getString("title");
            int streetId = rs.getInt("id");
            HashMap streets = (HashMap)result.get(cityId);
            if (streets == null) {
                streets = new HashMap();
                result.put(cityId, streets);
            }
            if ((map = (HashMap<String, Object>)streets.get(title.toLowerCase())) != null) continue;
            map = new HashMap<String, Object>();
            map.put("id", streetId);
            map.put("origin_title", title);
            streets.put(title.toLowerCase(), map);
        }
        rs.close();
        ps.close();
        return result;
    }

    public int addNewTariff(String title) throws SQLException {
        int treeId = new TariffTreeBuilder(this.con).createTree();
        String query = "INSERT INTO tariff_plan ( title, tree_id ) values ( ?, ? )";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, title);
        ps.setInt(2, treeId);
        ps.executeUpdate();
        int tpId = ServerUtils.lastInsertId(this.con);
        ps.close();
        return tpId;
    }

    public static List<Map<String, String>> loadTxtDB(String filePath, String charsetName, String splitRegexp, String ... fields) throws UnsupportedEncodingException, IOException {
        String[] lines;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        StringBuffer strBuffer = new StringBuffer();
        String[] stringArray = null;
        try (FileInputStream stream = new FileInputStream(filePath);){
            int count = 0;
            byte[] buff = new byte[1024];
            while ((count = ((InputStream)stream).read(buff, 0, 1024)) > 0) {
                strBuffer.append(new String(buff, 0, count, charsetName));
            }
        }
        catch (Throwable object) {
            stringArray = object;
            throw object;
        }
        for (String line : lines = strBuffer.toString().split("\n")) {
            line = line.trim();
            HashMap<String, String> map = new HashMap<String, String>();
            String[] words = line.split(splitRegexp, -1);
            int idx = 0;
            for (String fieldName : fields) {
                map.put(fieldName, idx < words.length ? words[idx++].trim() : null);
            }
            result.add(map);
        }
        return result;
    }

    public Map<Integer, Map<String, Integer>> getBillingHouseMap(String delim) throws SQLException {
        HashMap<Integer, Map<String, Integer>> result = new HashMap<Integer, Map<String, Integer>>();
        String query = "SELECT streetid, house, id, frac FROM address_house";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int steetId = rs.getInt(1);
            int house = rs.getInt(2);
            int houseId = rs.getInt(3);
            String frac = rs.getString(4);
            HashMap<String, Integer> houses = (HashMap<String, Integer>)result.get(steetId);
            if (houses == null) {
                houses = new HashMap<String, Integer>();
                result.put(steetId, houses);
            }
            String key = ConvertUtil.getHouseKey(house, frac, delim);
            houses.put(key, houseId);
        }
        rs.close();
        ps.close();
        return result;
    }

    private static String getHouseKey(int house, String frac, String delim) {
        String result = String.valueOf(house);
        if (frac != null) {
            frac = frac.trim();
        }
        if (!Utils.isEmptyString(frac)) {
            result = result + delim + frac.toLowerCase();
        }
        return result;
    }

    public void setBalance(int cid, Date date) throws BGException {
        this.balanceUtils.updateBalance(date, cid);
    }

    public BigDecimal getBalance(Date time, int cid) throws BGException {
        return this.balanceUtils.getBalance(time, cid);
    }

    public Map<String, Map<String, Object>> getBillingCityMap() throws SQLException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        String query = "SELECT id, title FROM address_city";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String title = rs.getString("title");
            int cityId = rs.getInt("id");
            HashMap<String, Object> map = (HashMap<String, Object>)result.get(title.toLowerCase());
            if (map == null) {
                map = new HashMap<String, Object>();
                map.put("id", cityId);
                map.put("origin_title", title);
                result.put(title.toLowerCase(), map);
                continue;
            }
            System.err.println("dublicate city " + title);
        }
        rs.close();
        ps.close();
        return result;
    }

    public Map<String, Map<String, Object>> getBillingCountryMap() throws SQLException {
        HashMap<String, Map<String, Object>> tarifMap = new HashMap<String, Map<String, Object>>();
        String query = "SELECT id, title FROM address_country";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int id = rs.getInt(1);
            String title = rs.getString(2);
            map.put("id", id);
            map.put("origin_title", title);
            tarifMap.put(title.toLowerCase(), map);
        }
        rs.close();
        ps.close();
        return tarifMap;
    }

    public void addContractGroup(int cid, int group) throws SQLException {
        this.contractManager.addContractGroup(cid, group);
    }

    public void addContractTariff(int cid, int tariffId, Date date1, String comment) throws BGException {
        ContractTariff contractTariff = new ContractTariff();
        contractTariff.setContractId(cid);
        contractTariff.setTariffPlanId(tariffId);
        contractTariff.getPeriod().setDateFrom(date1);
        contractTariff.setComment(comment);
        this.contractTariffDao.update(contractTariff);
    }

    public void addContractModule(int cid, int mid) throws BGException {
        this.contractModuleManager.addContractModule(cid, mid);
    }

    public void addContractParameter(int cid, int pid, String value) throws BGException {
        this.addContractParameter(cid, pid, value, null);
    }

    public void addContractParameter(int cid, int pid, String value, String comment) throws BGException {
        if (Utils.isEmptyString(value)) {
            return;
        }
        ContractParameterPref cpp = (ContractParameterPref)this.contractParameterPrefDao.get(pid);
        switch (cpp.getType()) {
            case TYPE_TEXT: {
                this.contractParameterManager.updateStringParam(cid, pid, value, 0);
                return;
            }
            case TYPE_EMAIL: {
                ContractEmailParamValue cepv = this.contractParameterManager.getEmailParam(cid, pid);
                if (cepv == null) {
                    cepv = new ContractEmailParamValue();
                }
                String emails = Utils.maskNull(cepv.getEmail()) + (Utils.notBlankString(cepv.getEmail()) ? "\n" : "") + comment + " " + value;
                cepv.setEmail(emails);
                this.contractParameterManager.updateEmailParam(cid, pid, cepv, 0);
                return;
            }
            case TYPE_DATE: {
                if (Utils.isBlankString(comment)) {
                    comment = "dd.MM.yyyy";
                }
                Date date = TimeUtils.parseDate(value, comment);
                this.contractParameterManager.updateDateParam(cid, pid, date, 0);
                return;
            }
            case TYPE_PHONE: {
                PhoneParamValue ppv = this.contractParameterManager.getPhoneParam(cid, pid);
                String phonesString = "";
                if (ppv == null) {
                    ppv = new PhoneParamValue();
                } else if (Utils.notBlankString(ppv.getPhones())) {
                    phonesString = phonesString + ppv.getPhones();
                }
                PhoneParamItem ppi = new PhoneParamItem();
                ppi.setPhone(value);
                if (Utils.notBlankString(comment)) {
                    ppi.setComment(comment);
                }
                ppv.addPhoneItem(ppi);
                phonesString = (Utils.notBlankString(phonesString) ? "; " : "") + value + (Utils.notBlankString(comment) ? " [" + comment + "]" : "");
                ppv.setPhones(phonesString);
                this.contractParameterManager.updatePhoneParam(cid, pid, ppv, 0);
                return;
            }
            case TYPE_FLAG: {
                this.contractParameterManager.updateFlagParam(cid, pid, Utils.parseBoolean(value), 0);
                return;
            }
            case TYPE_LIST: {
                int foundId = -1;
                try {
                    String query = "SELECT id, title FROM contract_parameter_type_7_values WHERE pid=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ps.setInt(1, pid);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        String title = rs.getString(2);
                        if (!Utils.notBlankString(title) || !value.trim().equalsIgnoreCase(title.trim())) continue;
                        foundId = id;
                        break;
                    }
                    rs.close();
                    ps.close();
                }
                catch (Exception e) {
                    throw new BGException("error get list values", e);
                }
                if (foundId <= 0) {
                    throw new BGMessageException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 (" + value + ") \u0434\u043b\u044f pid=" + pid + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e, cid=" + cid);
                }
                ListParamValue lpvalue = new ListParamValue();
                lpvalue.setId(foundId);
                this.contractParameterManager.updateListParam(cid, pid, lpvalue, 0);
                return;
            }
        }
        throw new RuntimeException("unsupported type '" + (Object)((Object)cpp.getType()) + "' parameter " + pid);
    }

    public void addContractAddressParameter(int cid, int pid, int countryId, int cityId, int streetId, int houseId, String flat, String streetUserValue, String houseUserValue) throws Exception {
        String comment = "";
        ContractAddressParamValue capValue = new ContractAddressParamValue();
        if (houseId > 0) {
            AddressStruct addressStruct = AddressUtils.getAddressStruct(this.con, houseId, flat, "", null, null, comment);
            capValue.setHouseId(houseId);
            capValue.setFlat(addressStruct.getFlat());
            capValue.setRoom(addressStruct.getRoom());
            capValue.setPod(0);
            capValue.setFloor(0);
            capValue.setComment(addressStruct.getComment());
            capValue.setFormatKey("0");
            String fullAddress = AddressUtils.getAddress(this.setup, addressStruct, "0");
            capValue.setAddress(fullAddress);
        } else {
            capValue.setHouseId(0);
            capValue.setFlat(null);
            capValue.setRoom("");
            capValue.setPod(0);
            capValue.setFloor(0);
            capValue.setComment(comment);
            capValue.setFormatKey(null);
            String fullAddress = streetUserValue + ", " + houseUserValue + " - " + flat;
            capValue.setAddress(fullAddress);
        }
        this.contractParameterManager.updateAddressParam(cid, pid, capValue, 0);
        new CommentPatternManager(this.con).updateContractComment(cid);
    }

    public String getContractParameter(int cid, int pid) throws BGException {
        ContractParameterPref cpp = (ContractParameterPref)this.contractParameterPrefDao.get(pid);
        switch (cpp.getType()) {
            case TYPE_TEXT: {
                return this.contractParameterManager.getStringParam(cid, pid);
            }
        }
        throw new RuntimeException("unsupported type '" + (Object)((Object)cpp.getType()) + "' parameter " + pid);
    }

    void updateNote(int cid, String title, String text) throws BGException {
        if (text == null) {
            return;
        }
        ContractNote note = new ContractNote();
        note.setTitle(title);
        note.setComment(text);
        note.setContractId(cid);
        note.setUserId(0);
        note.setVisible(false);
        note.setDateTime(new Date());
        try (ContractNoteDao noteDao = new ContractNoteDao(this.con);){
            noteDao.update(note);
        }
    }

    public bitel.billing.server.contract.bean.Contract createContract(int pattern_id, String title, String comment, Date date1) throws Exception {
        String passwd = PswdGen.generatePassword(this.setup);
        bitel.billing.server.contract.bean.Contract contract = this.contractManager.createFromPattern(pattern_id, title, TimeUtils.convertDateToCalendar(date1), passwd);
        if (contract != null && comment != null) {
            contract.setComment(comment);
            this.contractManager.updateContract(contract);
        }
        return contract;
    }

    public void addContractPayment(int cid, int paymentTypeId, Date date, BigDecimal sum, String comment) throws BGException {
        Payment payment = new Payment();
        payment.setDate(date);
        payment.setContractId(cid);
        payment.setTypeId(paymentTypeId);
        payment.setUserId(0);
        payment.setSum(sum);
        payment.setComment(comment);
        this.paymentDao.update(payment);
    }

    public void addContractCharge(int cid, int chargeTypeId, Date date, BigDecimal sum, String comment) throws BGException {
        Charge charge = new Charge();
        charge.setDate(date);
        charge.setContractId(cid);
        charge.setTypeId(chargeTypeId);
        charge.setUserId(0);
        charge.setSum(sum);
        charge.setComment(comment);
        this.chargeDao.update(charge);
    }

    public void closeContract(int cid, Date date, boolean fast) throws SQLException, BGException {
        if (fast) {
            bitel.billing.server.contract.bean.Contract contract = this.contractManager.getContractById(cid);
            contract.setDateTo(date);
            this.contractManager.updateContract(contract);
        } else {
            this.contractManager.closeContract(cid, 0, 0, date);
        }
    }

    public void setStatus(int cid, int status, Date dateFrom, String comment) throws BGException {
        this.setStatus(cid, status, dateFrom, comment, false);
    }

    public void setStatus(int cid, int status, Date dateFrom, String comment, boolean processEvent) throws BGException {
        ContractStatus newStatus = new ContractStatus();
        newStatus.setContractId(cid);
        newStatus.setStatus(status);
        newStatus.setDateFrom(dateFrom);
        newStatus.setComment(comment);
        this.contractStatusManager.changeStatus(newStatus, 0, processEvent);
    }

    public bitel.billing.server.contract.bean.Contract findContract(int pid, int houseId, String flat) throws SQLException, BGException {
        int cid;
        bitel.billing.server.contract.bean.Contract contract = null;
        String query = "SELECT cid FROM contract_parameter_type_2 WHERE pid=? AND hid=? AND flat=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setInt(2, houseId);
        ps.setString(3, flat);
        ResultSet rs = ps.executeQuery();
        if (rs.next() && (contract = this.contractManager.getContractById(cid = rs.getInt(1))) == null) {
            System.err.println("error contract on contract_parameter_type_2.cid=" + cid);
        }
        rs.close();
        ps.close();
        return contract;
    }

    public List<Contract> getContracts(long groupMask) throws BGException {
        ContractFilters contractFilters = new ContractFilters();
        contractFilters.setTitle(null);
        contractFilters.setComment(null);
        contractFilters.setFc(-2);
        contractFilters.setGroupMask(groupMask);
        contractFilters.setSubContracts(true);
        contractFilters.setClosed(false);
        contractFilters.setHidden(false);
        return this.contractDao.list(contractFilters, null, "title", null);
    }

    public static void removeContractsMultiThread(Connection con, Setup setup, int group, String exceptIds, int theadCount) throws SQLException, BGException {
        long groups = Utils.enumToMask(String.valueOf(group));
        String query = "SELECT id FROM contract WHERE gr & ? > 0 ";
        if (Utils.notBlankString(exceptIds)) {
            query = query + " AND id NOT IN (" + exceptIds + ")";
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(theadCount);
        ArrayList<RemoveThread> threads = new ArrayList<RemoveThread>();
        for (int i = 0; i < theadCount; ++i) {
            RemoveThread thread = new RemoveThread(setup);
            threads.add(thread);
            service.execute(thread);
        }
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setLong(1, groups);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    int idx = cid % theadCount;
                    ((RemoveThread)threads.get(idx)).addContract(cid);
                }
            }
            for (int i = 0; i < theadCount; ++i) {
                ((RemoveThread)threads.get(i)).finish();
            }
            service.shutdown();
            service.awaitTermination(5L, TimeUnit.HOURS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setGroup(int cid, int group) {
        try {
            String query = "UPDATE contract SET gr=gr|(1<<?) WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, group);
            ps.setInt(2, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unsetGroup(int cid, int group) {
        try {
            String query = "UPDATE contract SET gr=gr&~(1<<?) WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, group);
            ps.setInt(2, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendMail(String email, String subject, String body) {
        try {
            this.mailmsg.sendMessage(email, subject, body);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

