/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.filestorage.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;
import org.apache.commons.io.FilenameUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class FileStorage {
    public static final String FILE_STORAGE_ROOT_PATH = "file.storage.root.path";
    private String rootPath;
    private String storageId;
    private Connection con = null;

    public FileStorage(String rootPath, String storageId, Connection con) throws BGException {
        if (rootPath == null) {
            throw new BGException("FileStorage rootPath is null (check file.storage.root.path value?)");
        }
        this.rootPath = rootPath;
        this.storageId = storageId;
        this.con = con;
        try {
            this.makeTable();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public String getFileName(int fileId, String fileExtension) {
        String path;
        String sfid = String.valueOf(fileId);
        StringBuffer fname = new StringBuffer(64);
        for (int index = 0; index < sfid.length(); ++index) {
            if (index % 2 == 0) {
                fname.append(File.separatorChar);
            }
            fname.append(sfid.charAt(index));
        }
        final String root = this.rootPath + fname.toString();
        FilenameFilter fileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return FilenameUtils.getBaseName((String)name).equals(FilenameUtils.getBaseName((String)root));
            }
        };
        try {
            path = root.substring(0, root.lastIndexOf(File.separatorChar));
        }
        catch (IndexOutOfBoundsException exception) {
            path = FilenameUtils.getPath((String)root);
        }
        File[] files = new File(path).listFiles(fileNameFilter);
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                return path + File.separatorChar + file.getName();
            }
        }
        return this.rootPath + fname.toString() + "." + (Utils.isEmptyString(fileExtension) ? "dat" : fileExtension);
    }

    public String getFileName(int fileId) {
        return this.getFileName(fileId, null);
    }

    private void makeTable() throws SQLException {
        String query = "CREATE TABLE filestorage_files_list_" + this.storageId + " ( id INTEGER NOT NULL AUTO_INCREMENT, id_owner INTEGER NOT NULL, title VARCHAR(255) NOT NULL, size INTEGER NOT NULL, date TIMESTAMP NOT NULL, user INTEGER NOT NULL, comment TEXT, PRIMARY KEY (id) )";
        ServerUtils.checkTable(this.con, "filestorage_files_list_" + this.storageId, query);
    }

    public FileOutputStream save(int fileId, String fileExtension) throws IOException {
        File file = new File(this.getFileName(fileId, fileExtension));
        File filedir = new File(file.getParent());
        filedir.mkdirs();
        file.createNewFile();
        return new FileOutputStream(file);
    }

    public Path savePath(int fileId, String fileExtension) throws IOException {
        Path path = Paths.get(this.getFileName(fileId, fileExtension), new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path;
    }

    public FileOutputStream save(int fileId) throws IOException {
        return this.save(fileId, null);
    }

    public void saveStream(int fileId, InputStream is, String fileExtension) throws IOException {
        FileOutputStream out = this.save(fileId, fileExtension);
        Utils.flush(is, out);
        out.close();
    }

    public void saveFile(int fileId, Path srcPath, String fileExtension) throws IOException {
        Files.move(srcPath, this.savePath(fileId, fileExtension), new CopyOption[0]);
    }

    public void saveStream(int fileId, InputStream is) throws IOException {
        this.saveStream(fileId, is, null);
    }

    public FileInputStream load(int fileId) throws FileNotFoundException {
        return new FileInputStream(new File(this.getFileName(fileId)));
    }

    public void loadStream(int fileId, OutputStream out) throws FileNotFoundException, IOException {
        FileInputStream is = this.load(fileId);
        Utils.flush(is, out);
        is.close();
    }

    public DataSource getDataSource(final BGServerFile serverFile) throws FileNotFoundException {
        return new DataSource(){

            public String getContentType() {
                return "application/octet-stream";
            }

            public InputStream getInputStream() throws IOException {
                return FileStorage.this.load(serverFile.getId());
            }

            public String getName() {
                return serverFile.getTitle();
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        };
    }

    public void deleteFile(int fileId, String fileExtension) throws BGException {
        File file = new File(this.getFileName(fileId));
        if (!file.exists()) {
            file = new File(this.getFileName(fileId));
        }
        file.delete();
        try {
            String query = "DELETE FROM filestorage_files_list_" + this.storageId + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, fileId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void deleteFile(int fileId) throws BGException {
        this.deleteFile(fileId, null);
    }

    public void deleteByOwner(int ownerId, String fileExtension) throws SQLException {
        String query = "SELECT id FROM filestorage_files_list_" + this.storageId + " WHERE id_owner=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, ownerId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            try {
                int fileId = rs.getInt(1);
                File file = new File(this.getFileName(fileId));
                if (!file.exists()) {
                    file = new File(this.getFileName(fileId));
                }
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rs.close();
        ps.close();
        query = "DELETE FROM filestorage_files_list_" + this.storageId + " WHERE id_owner=?";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, ownerId);
        ps.executeUpdate();
        ps.close();
    }

    public void deleteByOwner(int ownerId) throws SQLException {
        this.deleteByOwner(ownerId, null);
    }

    public List<BGServerFile> getFilesListByOwner(int ownerId) throws BGException {
        try {
            ArrayList<BGServerFile> result = new ArrayList<BGServerFile>();
            String query = "SELECT df.*  FROM filestorage_files_list_" + this.storageId + " AS df  WHERE df.id_owner=" + ownerId + " ORDER BY df.date DESC ";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BGServerFile documentFile = new BGServerFile();
                FileStorage.loadFilesFromRS(documentFile, rs, "df.");
                result.add(documentFile);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public boolean hasFilesByOwner(int ownerId) throws BGException {
        try {
            boolean result = false;
            String query = "SELECT df.* FROM filestorage_files_list_" + this.storageId + " AS df WHERE df.id_owner=" + ownerId;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private static void loadFilesFromRS(BGServerFile file, ResultSet rs, String tableDocumentFile) throws SQLException {
        file.setId(rs.getInt(tableDocumentFile + "id"));
        file.setOwnerId(rs.getInt(tableDocumentFile + "id_owner"));
        file.setTitle(rs.getString(tableDocumentFile + "title"));
        file.setSize(rs.getLong(tableDocumentFile + "size"));
        file.setDate(rs.getTimestamp(tableDocumentFile + "date"));
        file.setUserId(rs.getInt(tableDocumentFile + "user"));
        file.setComment(rs.getString(tableDocumentFile + "comment"));
    }

    public void updateFile(BGServerFile file) throws BGException {
        try {
            String query = null;
            query = file.getId() > 0 ? "UPDATE filestorage_files_list_" + this.storageId + " SET id_owner=?, title=?, size=?, date=?, user=?, comment=?  WHERE id=?" : "INSERT INTO filestorage_files_list_" + this.storageId + " SET id_owner=?, title=?, size=?, date=?, user=?, comment=?";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, file.getOwnerId());
            ps.setString(2, file.getTitle());
            ps.setLong(3, file.getSize());
            ps.setTimestamp(4, TimeUtils.convertDateToTimestamp(file.getDate()));
            ps.setInt(5, file.getUserId());
            ps.setString(6, file.getComment());
            if (file.getId() > 0) {
                ps.setInt(7, file.getId());
            }
            ps.executeUpdate();
            if (file.getId() <= 0) {
                file.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public BGServerFile getFileById(int fileId) throws BGException {
        try {
            BGServerFile documentFile = null;
            String query = "SELECT * FROM filestorage_files_list_" + this.storageId + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, fileId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                documentFile = new BGServerFile();
                FileStorage.loadFilesFromRS(documentFile, rs, "");
            }
            rs.close();
            ps.close();
            return documentFile;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }
}

