/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp;

import bitel.billing.common.IPUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.common.Utils;

public final class DhcpPacket
implements Comparator<DhcpOption> {
    private static final Logger log = Logger.getLogger(DhcpPacket.class);
    public static final byte ZERO = 0;
    public static final Charset CHARSET = Charset.forName("ISO-8859-1");
    public static short FLAG_BROADCAST = Short.MIN_VALUE;
    public static final byte OP_BOOT_REQUEST = 1;
    public static final byte OP_BOOT_RESPONSE = 2;
    public static final int DHCP_DISCOVER = 1;
    public static final int DHCP_OFFER = 2;
    public static final int DHCP_REQUEST = 3;
    public static final int DHCP_DECLINE = 4;
    public static final int DHCP_ACK = 5;
    public static final int DHCP_NAK = 6;
    public static final int DHCP_RELEASE = 7;
    public static final int DHCP_INFORM = 8;
    private static String[] DHCP_MESSAGE_TYPES = new String[]{"", "DHCP Discover", "DHCP Offer", "DHCP Request", "DHCP Decline", "DHCP ACK", "DHCP NAK", "DHCP Release", "DHCP Inform"};
    private static final byte OPTION_END = -1;
    private static final byte OPTION_PADDING = 0;
    public static final byte OPTION_SUBNET_MASK = 1;
    public static final byte OPTION_TIME_OFFSET = 2;
    public static final byte OPTION_ROUTER = 3;
    public static final byte OPTION_TIME_SERVER = 4;
    public static final byte OPTION_NAME_SERVER = 5;
    public static final byte OPTION_DOMAIN_NAME_SERVER = 6;
    public static final byte OPTION_LOG_SERVER = 7;
    public static final byte OPTION_COOKIE_SERVER = 8;
    public static final byte OPTION_LPR_SERVER = 9;
    public static final byte OPTION_HOST_NAME = 12;
    public static final byte OPTION_DOMAIN_NAME = 15;
    public static final byte OPTION_REQUESTED_IP_ADDRESS = 50;
    public static final byte OPTION_IP_ADDRESS_LEASE_TIME = 51;
    private static final byte OPTION_OVERLOAD = 52;
    private static final byte OPTION_DHCP_MESSAGE_TYPE = 53;
    public static final byte OPTION_SERVER_IDENTIFIER = 54;
    public static final byte OPTION_RENEWAL_TIME_VALUE = 58;
    public static final byte OPTION_REBINDING_TIME_VALUE = 59;
    public static final byte OPTION_PARAMETER_REQUEST_LIST = 55;
    public static final byte OPTION_CLIENT_IDENTIDIER = 61;
    public static final byte OPTION_AGENT_INFORMATION = 82;
    private static final byte[] nullChaddr = new byte[16];
    private static final byte[] zeroArray = new byte[300];
    public byte op;
    public byte htype;
    public byte hlen;
    public byte hops;
    public int xid;
    public short secs;
    public short flags;
    public byte[] ciaddr = new byte[4];
    public byte[] yiaddr = new byte[4];
    public byte[] siaddr = new byte[4];
    public byte[] giaddr = new byte[4];
    public byte[] chaddr;
    public byte[] sname = new byte[64];
    public byte[] file = new byte[128];
    private List<DhcpOption> options = new ArrayList<DhcpOption>();
    private List<DhcpOption> subOptions;
    public byte messageType;
    private static final byte[] MAGIC_COOKIE = new byte[]{99, -126, 83, 99};
    private static final int MAGIC_COOKIE_LENGTH = MAGIC_COOKIE.length;
    private byte[] parameterRequestListOption;
    private Map<DhcpPacketOption<?>, Object> optionMap;
    private static final byte ZERO_BYTE = 0;

    public DhcpPacket() {
    }

    public DhcpPacket(ByteBuffer request) {
        this.parse(request);
    }

    public final DhcpPacket createResponse() {
        return new DhcpPacket(this);
    }

    private DhcpPacket(DhcpPacket request) {
        DhcpOption agentInfo;
        this.op = (byte)2;
        this.htype = request.htype;
        this.hlen = request.hlen;
        this.hops = request.hops;
        this.xid = request.xid;
        this.ciaddr = request.ciaddr;
        this.giaddr = request.giaddr;
        this.chaddr = request.chaddr;
        this.flags = request.flags;
        DhcpOption reqParams = request.getOption((byte)55);
        if (reqParams != null) {
            this.parameterRequestListOption = reqParams.value;
        }
        if ((agentInfo = request.getOption((byte)82)) != null) {
            this.setOption(agentInfo);
            this.subOptions = new ArrayList<DhcpOption>(request.subOptions);
        }
    }

    private void parse(ByteBuffer bb) {
        try {
            this.op = bb.get();
            this.htype = bb.get();
            this.hlen = bb.get();
            this.hops = bb.get();
            this.xid = bb.getInt();
            this.secs = bb.getShort();
            this.flags = bb.getShort();
            bb.get(this.ciaddr);
            bb.get(this.yiaddr);
            bb.get(this.siaddr);
            bb.get(this.giaddr);
            this.chaddr = new byte[this.hlen];
            bb.get(this.chaddr);
            bb.position(bb.position() + 16 - this.hlen);
            bb.get(this.sname);
            bb.get(this.file);
            bb.position(bb.position() + MAGIC_COOKIE_LENGTH);
            while (bb.hasRemaining()) {
                byte code = bb.get();
                if (code == 0) continue;
                if (code != -1) {
                    int len = bb.get() & 0xFF;
                    byte[] value = new byte[len];
                    bb.get(value);
                    this.setOption(code, value);
                    switch (code) {
                        case 53: {
                            this.messageType = value[0];
                            break;
                        }
                        case 52: {
                            log.error((Object)"Found not supported option: 52");
                            break;
                        }
                        case 82: {
                            this.readAgentInformation(value, len);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void readAgentInformation(byte[] data, int len) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        this.subOptions = new ArrayList<DhcpOption>(5);
        while (bb.hasRemaining()) {
            byte scode = bb.get();
            int slen = bb.get() & 0xFF;
            byte[] sval = new byte[slen];
            bb.get(sval);
            this.subOptions.add(new DhcpOption(scode, sval));
        }
    }

    public boolean haveSubOptions() {
        return this.subOptions != null;
    }

    public void clearSubOptions() {
        if (this.subOptions != null) {
            this.subOptions.clear();
        }
    }

    public void serialize(ByteBuffer bb) {
        int pos = bb.position();
        bb.put(this.op);
        bb.put(this.htype);
        bb.put(this.hlen);
        bb.put(this.hops);
        bb.putInt(this.xid);
        bb.putShort(this.secs);
        bb.putShort(this.flags);
        bb.put(this.ciaddr);
        bb.put(this.yiaddr);
        bb.put(this.siaddr);
        bb.put(this.giaddr);
        bb.put(this.chaddr);
        bb.put(nullChaddr, 0, 16 - this.chaddr.length);
        bb.put(this.sname);
        bb.put(this.file);
        bb.put(MAGIC_COOKIE);
        bb.put((byte)53);
        bb.put((byte)1);
        bb.put(this.messageType);
        if (this.parameterRequestListOption != null) {
            Collections.sort(this.options, this);
        }
        this.options.stream().filter(a2 -> a2.code != 82).forEach(option -> {
            bb.put(option.code);
            bb.put((byte)option.value.length);
            bb.put(option.value);
        });
        this.options.stream().filter(a2 -> a2.code == 82).forEach(option -> {
            bb.put(option.code);
            bb.put((byte)option.value.length);
            bb.put(option.value);
        });
        bb.put((byte)-1);
        int len = bb.position() - pos;
        int pad = 300 - len;
        if (pad > 0) {
            bb.put(zeroArray, 0, pad);
            assert (bb.position() - pos == 300);
        }
    }

    public final boolean isFromRelayAgent() {
        for (int i = 0; i < this.giaddr.length; ++i) {
            if (this.giaddr[i] == 0) continue;
            return true;
        }
        return false;
    }

    public final boolean isClientAddressSet() {
        for (int i = 0; i < this.ciaddr.length; ++i) {
            if (this.ciaddr[i] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int compare(DhcpOption o1, DhcpOption o2) {
        return this.getWeight(o1) - this.getWeight(o2);
    }

    private int getWeight(DhcpOption o) {
        if (o == null) {
            return 10000;
        }
        switch (o.code) {
            case 53: {
                return -10;
            }
            case 54: {
                return -9;
            }
            case 51: {
                return -8;
            }
            case 58: {
                return -7;
            }
            case 59: {
                return -6;
            }
        }
        for (int i = 0; i < this.parameterRequestListOption.length; ++i) {
            if (this.parameterRequestListOption[i] != o.code) continue;
            return i;
        }
        return 1000 + o.code;
    }

    public final void setOption(DhcpOption option) {
        if (option == null) {
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList<DhcpOption>(12);
            this.options.add(option);
        } else {
            int l = this.options.size();
            for (int i = 0; i < l; ++i) {
                DhcpOption o = this.options.get(i);
                if (option.code != o.code) continue;
                this.options.set(i, option);
                return;
            }
            this.options.add(option);
        }
    }

    public final void setOption(byte code, byte[] value) {
        this.setOption(new DhcpOption(code, value));
    }

    public final void setOption(byte code, String stringValue) {
        this.setOption(new DhcpOption(code, stringValue.getBytes(CHARSET)));
    }

    public final DhcpOption getOption(byte code) {
        return this.findOption(this.options, code);
    }

    public final void setSubOption(DhcpOption option) {
        if (option == null) {
            return;
        }
        if (this.subOptions == null) {
            this.subOptions = new ArrayList<DhcpOption>(12);
            this.subOptions.add(option);
        } else {
            int l = this.subOptions.size();
            for (int i = 0; i < l; ++i) {
                DhcpOption o = this.subOptions.get(i);
                if (option.code != o.code) continue;
                this.subOptions.set(i, option);
                return;
            }
            this.subOptions.add(option);
        }
    }

    public final void setSubOption(byte code, byte[] value) {
        this.setSubOption(new DhcpOption(code, value));
    }

    public final void setSubOption(byte code, String stringValue) {
        this.setSubOption(new DhcpOption(code, stringValue.getBytes(CHARSET)));
    }

    public final DhcpOption getSubOption(byte code) {
        return this.findOption(this.subOptions, code);
    }

    private DhcpOption findOption(List<DhcpOption> options, byte code) {
        if (options == null) {
            return null;
        }
        int l = options.size();
        for (int i = 0; i < l; ++i) {
            DhcpOption option = options.get(i);
            if (option.code != code) continue;
            return option;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(56);
        sb.append("Message type: ");
        if (this.op == 1) {
            sb.append("BOOT_REQUEST");
        } else if (this.op == 2) {
            sb.append("BOOT_RESPONSE");
        }
        sb.append("\n");
        sb.append("Dhcp message type: ").append(DHCP_MESSAGE_TYPES[this.messageType]).append("{").append(this.messageType).append("}").append("\n");
        sb.append("htype: ").append(this.htype).append(", ");
        sb.append("hlen: ").append(this.hlen).append(", ");
        sb.append("hops: ").append(this.hops).append("\n");
        sb.append("xid: ").append(this.xid).append(", ");
        sb.append("secs: ").append(this.secs).append(", ");
        sb.append("flags: ").append(Integer.toBinaryString(this.flags)).append("\n");
        sb.append("Client IP: ").append(IPUtils.convertIpToString(Utils.convertBytesToInt(this.ciaddr))).append("\n");
        sb.append("Your IP: ").append(IPUtils.convertIpToString(Utils.convertBytesToInt(this.yiaddr))).append("\n");
        sb.append("Server IP: ").append(IPUtils.convertIpToString(Utils.convertBytesToInt(this.siaddr))).append("\n");
        sb.append("Relay IP: ").append(IPUtils.convertIpToString(Utils.convertBytesToInt(this.giaddr))).append("\n");
        sb.append("Client MAC: ").append("{").append(Utils.bytesToHexString(this.chaddr)).append("}\n");
        block21: for (DhcpOption dhcpOption : this.options) {
            switch (dhcpOption.code) {
                case 53: {
                    continue block21;
                }
                case 82: {
                    sb.append("  ");
                    sb.append("Agent information{").append(dhcpOption.code).append("}=\n");
                    if (this.subOptions == null) continue block21;
                    for (DhcpOption subOption : this.subOptions) {
                        sb.append("    sub{").append(subOption.code).append("}=").append("{").append(Utils.bytesToHexString(subOption.value)).append("}\n");
                    }
                    continue block21;
                }
            }
            sb.append("  ");
            switch (dhcpOption.code) {
                case 54: {
                    sb.append("Server Identifier{").append(dhcpOption.code).append("}=").append("{").append(Utils.bytesToHexString(dhcpOption.value)).append("}");
                    break;
                }
                case 51: {
                    sb.append("IP Address Lease Time{").append(dhcpOption.code).append("}=").append(Utils.convertBytesToInt(dhcpOption.value));
                    break;
                }
                case 58: {
                    sb.append("Renewal (T1) Time Value{").append(dhcpOption.code).append("}=").append(Utils.convertBytesToInt(dhcpOption.value));
                    break;
                }
                case 59: {
                    sb.append("Rebinding (T2) Time Value{").append(dhcpOption.code).append("}=").append(Utils.convertBytesToInt(dhcpOption.value));
                    break;
                }
                case 15: {
                    sb.append("Domain{").append(dhcpOption.code).append("}=").append(new String(dhcpOption.value));
                    break;
                }
                case 6: {
                    sb.append("DNS{").append(dhcpOption.code).append("}=").append("{").append(Utils.bytesToHexString(dhcpOption.value)).append("}");
                    break;
                }
                case 12: {
                    sb.append("Host name{").append(dhcpOption.code).append("}=").append("{").append(new String(dhcpOption.value)).append("}");
                    break;
                }
                case 1: {
                    sb.append("Subnet mask{").append(dhcpOption.code).append("}=").append(IPUtils.convertIpToString(Utils.convertBytesToInt(dhcpOption.value)));
                    break;
                }
                case 3: {
                    sb.append("Router{").append(dhcpOption.code).append("}=").append(IPUtils.convertIpToString(Utils.convertBytesToInt(dhcpOption.value)));
                    break;
                }
                case 50: {
                    sb.append("Requested IP{").append(dhcpOption.code).append("}=").append(IPUtils.convertIpToString(Utils.convertBytesToInt(dhcpOption.value)));
                    break;
                }
                case 55: {
                    sb.append("Param request list{").append(dhcpOption.code).append("}=").append("{");
                    int size = dhcpOption.value.length;
                    for (int i = 0; i < size; ++i) {
                        sb.append(dhcpOption.value[i]).append(", ");
                    }
                    if (size > 0) {
                        sb.setLength(sb.length() - 2);
                    }
                    sb.append("}");
                    break;
                }
                case 57: {
                    sb.append("Max Msg Size{").append(dhcpOption.code).append("}=").append(Utils.bytesToInt(dhcpOption.value));
                    break;
                }
                case 61: {
                    sb.append("Client-ident.{").append(dhcpOption.code).append("}=").append("{").append(Utils.bytesToHexString(dhcpOption.value)).append("}");
                    break;
                }
                case 60: {
                    sb.append("Vendor class ident.{").append(dhcpOption.code).append("}=").append("{").append(Utils.bytesToHexString(dhcpOption.value)).append("}");
                    break;
                }
                case 81: {
                    sb.append("Client FQDN{").append(dhcpOption.code).append("}=").append("{").append(Utils.bytesToHexString(dhcpOption.value)).append("}");
                    break;
                }
                default: {
                    sb.append("{").append(dhcpOption.code).append("}").append("=").append("{").append(Utils.bytesToHexString(dhcpOption.value)).append("}");
                }
            }
            sb.append("\n");
        }
        if (this.optionMap != null && this.optionMap.size() > 0) {
            sb.append("Common options: {");
            for (Map.Entry entry : this.optionMap.entrySet()) {
                Object value = entry.getValue();
                sb.append(((DhcpPacketOption)entry.getKey()).name);
                if (value instanceof byte[]) {
                    sb.append("={").append(Utils.bytesToString((byte[])value, false, null)).append('}');
                } else if (value instanceof ByteBuffer) {
                    ByteBuffer bb = (ByteBuffer)value;
                    bb.mark();
                    byte[] result = new byte[bb.remaining()];
                    bb.get(result);
                    bb.reset();
                    sb.append("={").append(Utils.bytesToString(result, false, null)).append('}');
                } else {
                    sb.append('=').append(value);
                }
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append('}');
        }
        return sb.toString();
    }

    public <O> O getOption(DhcpPacketOption<O> option) {
        return (O)(this.optionMap == null ? null : this.optionMap.get(option));
    }

    public <O> O getOption(DhcpPacketOption<O> option, O value) {
        if (this.optionMap == null) {
            return value;
        }
        Object result = this.optionMap.get(option);
        if (result != null) {
            return (O)result;
        }
        return value;
    }

    public <O> void setOption(DhcpPacketOption<O> option, O value) {
        if (this.optionMap == null) {
            this.optionMap = new HashMap(8);
        }
        this.optionMap.put(option, value);
    }

    public static final boolean isNil(byte[] b2) {
        int size = b2.length;
        for (int i = 0; i < size; ++i) {
            if (b2[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isRenewRequest(DhcpPacket request) {
        return request.messageType == 3 && !DhcpPacket.isNil(request.ciaddr) && request.getOption((byte)54) == null && request.getOption((byte)50) == null;
    }

    public static class DhcpPacketOption<T> {
        final String name;

        public DhcpPacketOption(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : super.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DhcpPacketOption) {
                return this.name.equals(((DhcpPacketOption)o).name);
            }
            if (o instanceof String) {
                return this.name.equals(o);
            }
            return false;
        }
    }
}

