/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp.datalog.hourly;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLog;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.DhcpDataLog;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.DhcpDataLogReader;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public class DhcpHourlyDataLog
extends HourlyDataLog<ReadableDataLog<? extends DataLogReader<?>>, DataLogReader<?>, Object> {
    public DhcpHourlyDataLog(DefaultServerSetup setup, int sourceId, Calendar hour) {
        super(DhcpHourlyDataLog.path(setup, sourceId, "datalog.dhcp.dir"), hour);
    }

    public DhcpHourlyDataLog(File path, Calendar hour) {
        super(path, hour);
    }

    @Override
    protected DhcpDataLog newDataLog(File file, RandomAccessFile raf, FileChannel channel) {
        return new DhcpDataLog(DhcpHourlyDataLog.getDataLogId(file), file, raf, channel);
    }

    @Override
    protected final DhcpDataLogReader reader(DataLogReader<?> r) {
        return (DhcpDataLogReader)r;
    }

    public DhcpDataLogReader find(DhcpDataLogReader _reader, int dataLogId, int chunkId, int position) {
        DhcpDataLogReader reader;
        DhcpDataLogReader dhcpDataLogReader = reader = _reader != null ? _reader : (DhcpDataLogReader)this.nextReader(null, false);
        while (reader != null) {
            if (((DhcpDataLog)reader.getDataLog()).getId() == dataLogId) {
                if (!reader.find(chunkId, position)) break;
                return reader;
            }
            reader.moveToEnd();
            reader = (DhcpDataLogReader)this.nextReader(null, false);
        }
        return null;
    }
}

