/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.processor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorListener;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerTask;

public abstract class ProcessorRequest<C extends ThreadContext>
extends WorkerTask<C>
implements Runnable {
    private static final Logger logger = Logger.getLogger(ProcessorRequest.class);
    private final ProcessorListener listener;
    public final SocketAddress clientAddress;
    public final ByteBuffer data;
    public long millis;
    public long connectionId;

    public ProcessorRequest(ProcessorListener listener, SocketAddress clientAddress, long millis, ByteBuffer data) {
        this.listener = listener;
        this.clientAddress = clientAddress;
        this.millis = millis;
        this.data = data;
    }

    public void send(SocketAddress address, ByteBuffer response) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending to " + address));
        }
        this.listener.send(address, response);
    }
}

