/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.datalog.hourly;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLog;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLog;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogReader;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public class RadiusHourlyDataLog
extends HourlyDataLog<ReadableDataLog<? extends DataLogReader<?>>, DataLogReader<?>, Object> {
    public RadiusHourlyDataLog(DefaultServerSetup setup, int sourceId, Calendar hour) {
        this(setup, "datalog.radius.dir", sourceId, hour);
    }

    public RadiusHourlyDataLog(DefaultServerSetup setup, String key, int sourceId, Calendar hour) {
        super(RadiusHourlyDataLog.path(setup, sourceId, key), hour);
    }

    public RadiusHourlyDataLog(File path, Calendar hour) {
        super(path, hour);
    }

    @Override
    protected RadiusDataLog newDataLog(File file, RandomAccessFile raf, FileChannel channel) {
        return new RadiusDataLog(RadiusHourlyDataLog.getDataLogId(file), file, raf, channel);
    }

    @Override
    protected final RadiusDataLogReader reader(DataLogReader<?> r) {
        return (RadiusDataLogReader)r;
    }

    public RadiusDataLogReader find(RadiusDataLogReader _reader, int dataLogId, int chunkId, int position) {
        RadiusDataLogReader reader;
        RadiusDataLogReader radiusDataLogReader = reader = _reader != null ? _reader : (RadiusDataLogReader)this.nextReader(null, false);
        while (reader != null) {
            if (((RadiusDataLog)reader.getDataLog()).getId() == dataLogId) {
                if (!reader.find(chunkId, position)) break;
                return reader;
            }
            reader.moveToEnd();
            reader = (RadiusDataLogReader)this.nextReader(null, false);
        }
        return null;
    }

    public RadiusPacket find(int dataLogId, int chunkId, int position) {
        RadiusDataLogReader reader;
        while ((reader = (RadiusDataLogReader)this.nextReader(null, false)) != null) {
            if (((RadiusDataLog)reader.getDataLog()).getId() == dataLogId) {
                if (!reader.find(chunkId, position)) break;
                long[] millis = new long[1];
                return reader.read(millis);
            }
            reader.moveToEnd();
        }
        return null;
    }
}

