/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server;

import bitel.billing.server.contract.bean.ContractScriptManager;
import bitel.billing.server.script.bean.FunctionManager;
import bitel.billing.server.script.bean.ScriptManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.script.common.EventScriptService;
import ru.bitel.bgbilling.kernel.script.common.ScriptFunctionModifiedEvent;
import ru.bitel.bgbilling.kernel.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.script.common.bean.EventScriptLink;
import ru.bitel.bgbilling.kernel.script.common.bean.EventType;
import ru.bitel.bgbilling.kernel.script.server.bean.EventScriptLinkDao;
import ru.bitel.bgbilling.kernel.script.server.bean.EventTypeManager;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptBackupManager;
import ru.bitel.bgbilling.kernel.script.server.dev.EventScript;
import ru.bitel.bgbilling.kernel.script.server.dev.EventScriptBase;
import ru.bitel.bgbilling.kernel.script.server.event.EventScriptLinkDeletedEvent;
import ru.bitel.bgbilling.kernel.script.server.event.EventScriptLinkModifiedEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.script.common.EventScriptService")
public class EventScriptServiceImpl
extends AbstractService
implements EventScriptService {
    @Override
    public List<EventType> getEventTypeList(int mode, boolean onlyNew) {
        EventTypeManager eventTypeManager = new EventTypeManager(this.getConnection());
        List<EventType> result = eventTypeManager.getEventTypeList(mode);
        if (onlyNew) {
            result = eventTypeManager.filterNewEvents(result);
        }
        this.fillTitles(result);
        return result;
    }

    @Override
    public List<IdTitle> getScriptList() {
        return new ScriptManager(this.getConnection()).getScriptList().stream().map(f -> new IdTitle(f.getId(), f.getTitle())).collect(Collectors.toList());
    }

    @Override
    public List<EventScriptLink> getEventLinksByScript(int scriptId) throws BGException {
        if (scriptId < -1) {
            throw new BGIllegalArgumentException();
        }
        try (EventScriptLinkDao dao = new EventScriptLinkDao(this.getConnection());){
            List<EventScriptLink> list = dao.getScriptLinkListByScript(scriptId);
            return list;
        }
    }

    @Override
    public void updateEventScriptLink(EventScriptLink link) throws BGException {
        if (Utils.isBlankString(link.getClassName()) || " --- ".equals(link.getClassName())) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u043a\u043b\u0430\u0441\u0441\u0430.");
        }
        if (Utils.isBlankString(link.getEventKey())) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u0435.");
        }
        if (Utils.isBlankString(link.getTitle())) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u0441\u043a\u0440\u0438\u043f\u0442\u0430.");
        }
        try (EventScriptLinkDao eventScriptLinkDao = new EventScriptLinkDao(this.getConnection());){
            eventScriptLinkDao.update(link);
        }
        EventProcessor.getInstance().publish(new EventScriptLinkModifiedEvent(link));
    }

    @Override
    public EventScriptLink getEventScriptLink(int id) throws BGException {
        try (EventScriptLinkDao eventScriptLinkDao = new EventScriptLinkDao(this.getConnection());){
            EventScriptLink eventScriptLink = (EventScriptLink)eventScriptLinkDao.get(id);
            return eventScriptLink;
        }
    }

    @Override
    public void deleteEventScriptLink(int id) throws BGException {
        try (EventScriptLinkDao eventScriptLinkDao = new EventScriptLinkDao(this.getConnection());){
            eventScriptLinkDao.delete(id);
        }
        EventProcessor.getInstance().publish(new EventScriptLinkDeletedEvent(id));
    }

    private void fillTitles(List<EventType> types) {
        for (EventType eventType : types) {
            String title = eventType.getTitle();
            String moduleId = eventType.getModuleId();
            if (!moduleId.equals("0")) {
                if (moduleId.startsWith("p")) {
                    int pluginUid = Utils.parseInt(moduleId.substring(1));
                    BGPluginServer plugin = BGPluginManagerServer.getManager().getPluginByUID(pluginUid);
                    if (plugin != null) {
                        title = "\u041f\u043b\u0430\u0433\u0438\u043d " + plugin.getName() + " => " + title;
                    }
                } else {
                    BGModule module = ModuleCache.getInstance().getModule(Utils.parseInt(moduleId));
                    if (module != null) {
                        title = "\u041c\u043e\u0434\u0443\u043b\u044c " + module.getTitle() + " => " + title;
                    }
                }
            }
            eventType.setTitle(title);
        }
    }

    @Override
    public List<EventType> getEventTypesByEventId(String eventId) throws BGException {
        return new EventTypeManager(this.getConnection()).getEventTypesByEventId(eventId);
    }

    @Override
    public List<EventScriptLink> getEventLinks() throws BGException {
        try (EventScriptLinkDao eventScriptLinkDao = new EventScriptLinkDao(this.getConnection());){
            List<EventScriptLink> list = eventScriptLinkDao.getScriptLinkList();
            return list;
        }
    }

    @Override
    public String getInterfaceName() {
        return EventScript.class.getName();
    }

    @Override
    public String getSuperclassName() {
        return EventScriptBase.class.getName();
    }

    @Override
    public void deleteFunction(int id) throws BGException {
        Connection con = this.getConnection();
        try (ScriptBackupManager scriptBackupManager = new ScriptBackupManager(con);){
            scriptBackupManager.deleteBackups(id, 1);
        }
        new FunctionManager(con).deleteFunction(id);
        try {
            con.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        EventProcessor.getInstance().publish(new ScriptFunctionModifiedEvent(id));
    }

    @Override
    public ContractScript getContractScript(int id) throws BGException {
        return new ContractScriptManager(this.getConnection()).getContractScriptById(id);
    }
}

