/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.script.common.GlobalScriptService;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLink;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLog;
import ru.bitel.bgbilling.kernel.script.server.bean.GlobalScriptInvoker;
import ru.bitel.bgbilling.kernel.script.server.bean.GlobalScriptLinkDao;
import ru.bitel.bgbilling.kernel.script.server.bean.GlobalScriptLogDao;
import ru.bitel.bgbilling.kernel.script.server.dev.GlobalScript;
import ru.bitel.bgbilling.kernel.script.server.dev.GlobalScriptBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.script.common.GlobalScriptService")
public class GlobalScriptServiceImpl
extends AbstractService
implements GlobalScriptService {
    private GlobalScriptLinkDao linkDao = null;

    private GlobalScriptLinkDao getLinkDao() {
        if (this.linkDao == null) {
            this.linkDao = new GlobalScriptLinkDao(this.getConnection());
        }
        return this.linkDao;
    }

    @Override
    public void updateGlobalScriptLink(GlobalScriptLink link) throws BGException {
        this.getLinkDao().update(link);
    }

    @Override
    public GlobalScriptLink getGlobalScriptLink(int id) throws BGException {
        return (GlobalScriptLink)this.getLinkDao().get(id);
    }

    @Override
    public List<GlobalScriptLink> getGlobalScriptLinkList() throws BGException {
        return this.getLinkDao().getList();
    }

    @Override
    public void deleteGlobalScriptLink(int id) throws BGException {
        this.getLinkDao().delete(id);
    }

    @Override
    public String executeGlobalScript(int id) throws BGException {
        return this.executeGlobalScriptParams(id, null);
    }

    /*
     * Loose catch block
     */
    @Override
    public String executeGlobalScriptParams(int id, ParameterMap params) throws BGException {
        GlobalScriptLink globalScriptLink = (GlobalScriptLink)this.getLinkDao().get(id);
        if (globalScriptLink == null) {
            throw new BGIllegalArgumentException();
        }
        ByteArrayOutputStream outBaos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outBaos);
        ByteArrayOutputStream errBaos = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(errBaos);
        ByteArrayOutputStream exBaos = new ByteArrayOutputStream();
        PrintStream ex = new PrintStream(exBaos);
        GregorianCalendar startTime = new GregorianCalendar();
        try {
            GlobalScriptInvoker.invoke(globalScriptLink.getClassName(), this.getConnectionSet(), out, err, params);
        }
        catch (Throwable e) {
            e.printStackTrace(ex);
            e.printStackTrace();
        }
        String tableName = ServerUtils.getMonthTableName("log_gscript_process", new GregorianCalendar().getTime());
        Connection trashCon = Setup.getSetup().getDBTrashOrMasterConnectionFromPool(tableName);
        try {
            try (GlobalScriptLogDao logDao = new GlobalScriptLogDao(trashCon, tableName);){
                String string = logDao.writeLog(globalScriptLink.getTitle(), outBaos.toString(), errBaos.toString(), exBaos.toString(), startTime);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ServerUtils.closeConnection(trashCon);
        }
    }

    @Override
    public String getInterfaceName() {
        return GlobalScript.class.getName();
    }

    @Override
    public String getSuperclassName() {
        return GlobalScriptBase.class.getName();
    }

    /*
     * Loose catch block
     */
    @Override
    public List<GlobalScriptLog> getGlobalScriptLogList(Period period, String title, Holder<Page> pageHolder) throws BGException, BGMessageException {
        String tableName = ServerUtils.getMonthTableName("log_gscript_process", period.getDateFrom());
        Connection trashCon = Setup.getSetup().getDBTrashOrMasterConnectionFromPool(tableName);
        try {
            try (GlobalScriptLogDao logDao = new GlobalScriptLogDao(trashCon, tableName);){
                List<GlobalScriptLog> list = logDao.getScriptLogList(period, title, pageHolder != null ? (Page)pageHolder.value : null);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ServerUtils.closeConnection(trashCon);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<String> getScriptLogTitleList(Period period) throws BGException, BGMessageException {
        if (period == null || period.getDateFrom() == null) {
            throw new BGIllegalArgumentException();
        }
        String tableName = ServerUtils.getMonthTableName("log_gscript_process", period.getDateFrom());
        Connection con = this.getSetup().getDBTrashOrSlaveConnectionFromPool(tableName);
        try {
            try (GlobalScriptLogDao logDao = new GlobalScriptLogDao(con, tableName);){
                List<String> list = logDao.getScriptLogTitleList(period);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }
}

