/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.sqleditor.server.action;

import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.util.MailMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class ActionSQLEditor
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws SQLException, BGException {
        Connection baseCon = this.con;
        try {
            Page page = this.getPage();
            String clientSqlQuery = this.getParameter("sql");
            if (Utils.isEmptyString(clientSqlQuery)) {
                return;
            }
            clientSqlQuery = clientSqlQuery.trim();
            String sqlQuery = clientSqlQuery.trim().toLowerCase();
            String base = this.getParameter("base");
            if (base != null && !base.equals("main")) {
                String[] ss = base.split("@");
                if (ss.length < 2) {
                    throw new BGIllegalArgumentException();
                }
                if (ss[0].equals("slave")) {
                    baseCon = this.setup.getSlaveConnectionFromPool(ss[1]);
                } else if (ss[0].equals("trash")) {
                    baseCon = this.setup.getTrashConnectionFromPool(ss[1]);
                } else {
                    throw new BGIllegalArgumentException();
                }
            }
            Element table = this.createElement(this.rootNode, "table");
            Element head = this.createElement(table, "head");
            Element data = this.createElement(table, "data");
            boolean pages = false;
            try {
                if (sqlQuery.startsWith("select")) {
                    clientSqlQuery = clientSqlQuery.replaceFirst("(?i)select", "SELECT SQL_CALC_FOUND_ROWS ");
                    if (!Pattern.compile("(?i)limit((,)?\\s*\\d+\\s*){1,2}").matcher(clientSqlQuery).find()) {
                        pages = true;
                        if (page.getPageSize() > 0) {
                            clientSqlQuery = clientSqlQuery + page.sqlLimit();
                        }
                    }
                }
                Statement statement = baseCon.createStatement();
                boolean res = statement.execute(clientSqlQuery);
                if (sqlQuery.startsWith("select")) {
                    try {
                        page.setRecordCount(ServerUtils.foundRows(baseCon));
                    }
                    catch (SQLException e) {
                        page.setRecordCount(50000);
                    }
                }
                if (res) {
                    String maildest = this.getParameter("maildest");
                    if (Utils.isBlankString(maildest)) {
                        ResultSet rs = statement.getResultSet();
                        ResultSetMetaData meta = rs.getMetaData();
                        int columnCount = meta.getColumnCount();
                        String[] columns = new String[columnCount];
                        for (int i = 0; i < columnCount; ++i) {
                            columns[i] = "row" + i;
                            this.createElement(head, columns[i]).setAttribute("title", meta.getColumnLabel(i + 1));
                        }
                        head.setAttribute("column_count", String.valueOf(columnCount));
                        int recordCount = 0;
                        while (rs.next()) {
                            Element row = this.createElement(data, "row");
                            for (int i = 0; i < columnCount; ++i) {
                                row.setAttribute(columns[i], rs.getString(i + 1));
                            }
                            ++recordCount;
                        }
                        rs.close();
                        if (page.getRecordCount() == 0) {
                            page.setRecordCount(recordCount);
                        }
                    } else {
                        try {
                            int i;
                            final ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
                            String charset = "UTF-8";
                            ResultSet rs = statement.getResultSet();
                            ResultSetMetaData meta = rs.getMetaData();
                            int columnCount = meta.getColumnCount();
                            for (i = 0; i < columnCount; ++i) {
                                baos.write(meta.getColumnName(i + 1).getBytes(charset));
                                if (i >= columnCount - 1) continue;
                                baos.write(";".getBytes(charset));
                            }
                            baos.write("\r\n\r\n".getBytes(charset));
                            while (rs.next()) {
                                for (i = 0; i < columnCount; ++i) {
                                    if (rs.getString(i + 1) != null) {
                                        baos.write(rs.getString(i + 1).getBytes(charset));
                                    }
                                    if (i >= columnCount - 1) continue;
                                    baos.write(";".getBytes(charset));
                                }
                                baos.write("\r\n".getBytes(charset));
                            }
                            rs.close();
                            MimeMultipart m = new MimeMultipart();
                            MimeBodyPart content = new MimeBodyPart();
                            content.setText(clientSqlQuery, charset);
                            m.addBodyPart((BodyPart)content);
                            MimeBodyPart attach = new MimeBodyPart();
                            m.addBodyPart((BodyPart)attach);
                            DataSource ds = new DataSource(){

                                public String getContentType() {
                                    return "text/plain";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(baos.toByteArray());
                                }

                                public String getName() {
                                    return null;
                                }

                                public OutputStream getOutputStream() throws IOException {
                                    return null;
                                }
                            };
                            attach.setDataHandler(new DataHandler(ds));
                            attach.setFileName("sql" + System.currentTimeMillis() + ".csv");
                            MailMsg msg = new MailMsg(this.setup);
                            msg.sendMessage(maildest, "query result", (Multipart)m);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new BGMessageException("\u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
                        }
                    }
                } else {
                    this.createElement(head, "Updated");
                    Element row = this.createElement(data, "row");
                    row.setAttribute("Updated", String.valueOf(statement.getUpdateCount()));
                }
                statement.close();
                if (!pages) {
                    page.setPageCount(1);
                    page.setPageIndex(1);
                }
                this.setPageAttribute(head, page);
            }
            catch (SQLException ex) {
                this.createElement(head, "Error");
                Element row = this.createElement(data, "row");
                row.setAttribute("Error", ex.getMessage());
            }
            ServerUtils.prepareElementToSerialize(this.rootNode);
        }
        finally {
            if (baseCon != this.con) {
                ServerUtils.closeConnection(baseCon);
            }
        }
    }
}

