/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TreeContext;
import ru.bitel.common.worker.ThreadContext;

public final class TariffModuleTree
extends ReentrantLock {
    private final TariffTreeNodeHolder rootNode;
    private final int treeId;
    private final int mid;
    private final String module;
    long lmTimeAtInit;
    private final WeakHashMap<TariffContext, TreeContext> treeContextMap = new WeakHashMap();
    private static final Long ZERO = 0L;

    public TariffModuleTree(TariffTreeNodeHolder rootNode, int treeId, int mid, String module) {
        this.rootNode = rootNode;
        this.treeId = treeId;
        this.mid = mid;
        this.module = module;
        this.lmTimeAtInit = -1L;
    }

    private TreeContext getTreeContext(TariffContext context) {
        TreeContext result;
        this.lock();
        try {
            result = this.treeContextMap.get(context);
            if (result == null) {
                result = context.createTreeContext(this);
                this.treeContextMap.put(context, result);
            }
        }
        finally {
            this.unlock();
        }
        return result;
    }

    public int execute(AbstractTariffRequest<?> req, TariffContext context) {
        if (this.rootNode != null) {
            return this.rootNode.execute(ZERO, req, context, this.getTreeContext(context), null);
        }
        req.addError("Root node for tariff not found!");
        return 0;
    }

    public int execute(AbstractTariffRequest<?> req, TariffContext context, ThreadContext workerContext) {
        if (this.rootNode != null) {
            return this.rootNode.execute(ZERO, req, context, this.getTreeContext(context), workerContext);
        }
        req.addError("Root node for tariff not found!");
        return 0;
    }

    public List<TariffTreeNodeHolder> getPath(TariffTreeNodeHolder child) {
        ArrayList<TariffTreeNodeHolder> result = new ArrayList<TariffTreeNodeHolder>();
        this.getPath0(child, this.rootNode, result);
        Collections.reverse(result);
        return result;
    }

    private boolean getPath0(TariffTreeNodeHolder find, TariffTreeNodeHolder parent, List<TariffTreeNodeHolder> path) {
        if (parent.treeNodeId.equals(find.treeNodeId)) {
            return true;
        }
        int size = parent.children.length;
        for (int i = 0; i < size; ++i) {
            if (!this.getPath0(find, parent.children[i], path)) continue;
            path.add(parent.children[i]);
            return true;
        }
        return false;
    }

    public int getTreeId() {
        return this.treeId;
    }

    public int getMid() {
        return this.mid;
    }

    public String getModule() {
        return this.module;
    }

    public TariffTreeNodeHolder getRootNode() {
        return this.rootNode;
    }

    public void getNodeList(List<TariffTreeNodeHolder> result, Class<?> ... classes) {
        HashSet classSet = new HashSet(Arrays.asList(classes));
        this.rootNode.getNodeList(result, classSet);
    }
}

