/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server.npay;

import java.math.BigDecimal;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.tariff.tree.server.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.npay.tariff.server.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.tariff.server.NPayTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class MonthModeCostTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    protected final BigDecimal cost;
    protected final int type;

    public MonthModeCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
        this.type = parameterMap.getInt("type", 0);
    }

    @Override
    protected int executeImpl(Long treeNodeId, NPayTariffRequest tariffRequest, NPayTariffContext tariffContext) {
        BigDecimal cost;
        int monthDays = tariffRequest.getAccountingMonthDays();
        int periodDays = ((NPayTariffRequest.NPayServiceCost)tariffRequest.serviceCost).accountingPeriodDays;
        BigDecimal monthAmount = ((NPayTariffRequest.NPayServiceCost)tariffRequest.serviceCost).monthAmount;
        BigDecimal periodAmount = ((NPayTariffRequest.NPayServiceCost)tariffRequest.serviceCost).periodAmount;
        switch (this.type) {
            case 0: {
                if (periodDays > 0) {
                    cost = this.cost;
                    break;
                }
                cost = BigDecimal.ZERO;
                break;
            }
            case 1: {
                cost = this.cost.multiply(BigDecimal.valueOf(periodDays), tariffContext.mc).divide(BigDecimal.valueOf(monthDays), tariffContext.mc);
                break;
            }
            case 2: {
                if (monthAmount != null && periodAmount != null) {
                    cost = this.cost.multiply(periodAmount, tariffContext.mc).divide(monthAmount, tariffContext.mc);
                    break;
                }
                cost = BigDecimal.ZERO;
                break;
            }
            case 3: {
                BigDecimal costPropAmount;
                cost = this.cost.multiply(BigDecimal.valueOf(periodDays), tariffContext.mc).divide(BigDecimal.valueOf(monthDays), tariffContext.mc);
                if (monthAmount == null || periodAmount == null || (costPropAmount = this.cost.multiply(periodAmount, tariffContext.mc).divide(monthAmount, tariffContext.mc)).compareTo(cost) <= 0) break;
                cost = costPropAmount;
                break;
            }
            case 4: {
                if (periodDays > 0) {
                    Calendar startMonth = TimeUtils.getStartMonth(tariffContext.getCurrentDay());
                    startMonth = TimeUtils.clear_HOUR_MIN_MIL_SEC(startMonth);
                    Calendar endMonth = TimeUtils.getEndMonth(tariffContext.getCurrentDay());
                    Calendar dateFrom = tariffRequest.tariffDateFrom;
                    Calendar dateTo = tariffRequest.tariffDateTo;
                    if (dateFrom == null || TimeUtils.dateBefore(dateFrom, startMonth)) {
                        dateFrom = startMonth;
                    }
                    if (dateTo == null || TimeUtils.dateBefore(endMonth, dateTo)) {
                        dateTo = endMonth;
                    }
                    int periodDaysTariff = dateTo.get(5) - dateFrom.get(5) + 1;
                    cost = this.cost.multiply(BigDecimal.valueOf(periodDaysTariff), tariffContext.mc).divide(BigDecimal.valueOf(monthDays), tariffContext.mc);
                    break;
                }
                cost = BigDecimal.ZERO;
                break;
            }
            default: {
                cost = BigDecimal.ZERO;
            }
        }
        ((NPayTariffRequest.NPayServiceCost)tariffRequest.serviceCost).cost = cost;
        return 1;
    }
}

