/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.update.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.base.server.servlet.ClientUpdate;
import ru.bitel.bgbilling.kernel.update.server.LibInfo;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class LibInfoUtil {
    private static final String SHA_256 = "SHA-256";
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private static Map<String, LibInfo> clientLibInfos = null;
    private static Map<String, List<LibInfo>> appsLibInfos = null;

    public static Map<String, LibInfo> getClientLibInfos() {
        if (clientLibInfos == null) {
            Logger logger;
            URI clientJars;
            block22: {
                clientLibInfos = new HashMap<String, LibInfo>();
                clientJars = null;
                logger = Logger.getLogger(LibInfoUtil.class);
                try {
                    clientJars = ClassLoader.getSystemResource("client.jars").toURI();
                    logger.info((Object)("clientJars=" + clientJars));
                }
                catch (Exception e) {
                    File[] path;
                    String prop = System.getProperty("client.jars");
                    if (prop != null && Files.isDirectory((Path)(path = Paths.get(prop, new String[0])), new LinkOption[0])) {
                        clientJars = path.toUri();
                    }
                    if (clientJars != null) break block22;
                    logger.error((Object)"Folder \"client.jars\" not found!");
                    return clientLibInfos;
                }
            }
            File libsDir = new File(clientJars);
            if (libsDir.exists() && libsDir.isDirectory()) {
                ArrayList<LibInfo> list = new ArrayList<LibInfo>();
                for (File libDir : libsDir.listFiles()) {
                    if (!libDir.isDirectory()) continue;
                    for (File libFile : libDir.listFiles()) {
                        LibInfo libInfo = new LibInfo();
                        libInfo.setFile(libFile);
                        libInfo.setName(LibInfoUtil.getLibName(libFile.getName()));
                        libInfo.setHash(LibInfoUtil.sha256Hex(libFile.getPath()));
                        clientLibInfos.put(libInfo.getName(), libInfo);
                        list.add(libInfo);
                    }
                }
                StringBuilder versions = new StringBuilder();
                Collections.sort(list, new LibInfo());
                for (LibInfo libInfo : list) {
                    versions.append(libInfo.getHash());
                }
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(versions.toString().getBytes("UTF-8"));){
                    String clientVersion = LibInfoUtil.sha256Hex(byteArrayInputStream);
                    Setup.getSetup().set("bg.client.version", clientVersion);
                    logger.info((Object)("Set bg.client.version=" + clientVersion));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return clientLibInfos;
    }

    public static Map<String, List<LibInfo>> getAppsLibInfos() {
        if (appsLibInfos == null) {
            appsLibInfos = new HashMap<String, List<LibInfo>>();
            Document appsDocument = null;
            try {
                appsDocument = XMLUtils.parseDocument(new InputSource(LibInfoUtil.class.getResourceAsStream("/data/apps.xml")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (appsDocument != null) {
                for (Element apps : XMLUtils.selectElements(appsDocument.getDocumentElement(), "/data/apps")) {
                    String type = apps.getAttribute("type");
                    if (!Utils.notBlankString(type)) continue;
                    ArrayList<LibInfo> list = new ArrayList<LibInfo>();
                    XMLUtils.selectElements(apps, "lib").forEach(e -> list.add(new LibInfo(e.getAttribute("type"), e.hasAttribute("dir") ? e.getAttribute("dir") : null, e.getAttribute("name"))));
                    LibInfoUtil.addAppLib(list);
                    appsLibInfos.put(type, list);
                }
            }
        }
        return appsLibInfos;
    }

    private static void addAppLib(List<LibInfo> list) {
        String libDir = System.getProperty("lib.dir");
        try {
            File libAppDir = null;
            if (libDir != null) {
                libAppDir = new File(libDir + File.separator + "lib/app");
            } else {
                URL url = ClientUpdate.class.getResource("/lib/app");
                if (url != null) {
                    libAppDir = new File(url.toURI());
                }
            }
            if (libAppDir != null) {
                for (File libAppFile : libAppDir.listFiles()) {
                    if (!libAppFile.exists() || !libAppFile.isFile() || !libAppFile.getName().endsWith(".jar")) continue;
                    String name = libAppFile.getName();
                    name = name.substring(0, name.length() - 4);
                    list.add(new LibInfo("app", null, name));
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static String getLibName(String name) {
        int index;
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        if ((index = name.lastIndexOf(45)) > -1 && index + 1 < name.length() && Character.isDigit(name.charAt(index + 1))) {
            name = name.substring(0, index);
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sha256Hex(String fileName) {
        try (InputStream is = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);){
            String string = LibInfoUtil.sha256Hex(is);
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha256Hex(InputStream data) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(SHA_256);
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return Utils.bytesToHexString(digest.digest());
    }
}

