/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.dhcp;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.server.util.ARPUtil;
import ru.bitel.common.TimeUtils;

public class DHCPChecker
extends Thread {
    private static Logger log = Logger.getLogger(DHCPChecker.class);
    private Map<String, Integer> macHash = new ConcurrentHashMap<String, Integer>();
    ARPUtil arpUtil = new ARPUtil();
    private static int TIME_DELTA = 0;

    public DHCPChecker() {
        this.restoreData();
    }

    public void addEntry(String ip, String mac, Integer leaseTime) {
        int now = (int)(new Date().getTime() / 1000L);
        int until = now + leaseTime;
        this.macHash.put(mac, until);
        log.debug((Object)("DHCPChecker: added new ip=" + ip + ",mac = " + mac + ", leaseTime(sec)=" + leaseTime + " (until " + this.showTime(until) + ")"));
        this.saveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreData() {
        this.macHash.clear();
        log.info((Object)"DHCPChecker: restoting lease info...");
        BufferedReader reader = null;
        try {
            FileInputStream stream = new FileInputStream("leaseInfo");
            reader = new BufferedReader(new InputStreamReader(stream));
            byte[] buf = new byte[4];
            int len = this.readInt(reader, buf);
            log.info((Object)("DHCPChecker: restored count =  " + len));
            for (int i = 0; i < len; ++i) {
                String mac = reader.readLine();
                int leaseTime = this.readInt(reader, buf);
                log.info((Object)("DHCPChecker: restored mac =  " + mac + ";leaseTime=" + leaseTime + " (until " + this.showTime(leaseTime) + ")"));
                this.macHash.put(mac, leaseTime);
            }
        }
        catch (Exception e) {
            log.info((Object)"DHCPChecker: restoring failed.");
            this.macHash.clear();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData() {
        log.info((Object)"DHCPChecker: saving lease info..");
        OutputStreamWriter writer = null;
        try {
            FileOutputStream stream = new FileOutputStream("leaseInfo");
            writer = new OutputStreamWriter(stream);
            writer.write(Integer.valueOf(this.macHash.size()).toString() + "\n");
            for (Map.Entry<String, Integer> entry : this.macHash.entrySet()) {
                writer.write(entry.getKey() + "\n");
                writer.write(entry.getValue() + "\n");
                log.info((Object)("DHCPChecker: saving mac =  " + entry.getKey() + ";leaseTime(sec)=" + entry.getValue() + " (until " + this.showTime(entry.getValue().intValue()) + ")"));
            }
        }
        catch (Exception e) {
            log.info((Object)"DHCPChecker: saving failed");
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void run() {
        log.debug((Object)"DHCPChecker starting...");
        while (true) {
            try {
                while (true) {
                    Map<String, String> macs = ARPUtil.getMACs();
                    for (Map.Entry<String, String> entry : macs.entrySet()) {
                        String ip = entry.getKey();
                        String mac = entry.getValue();
                        Integer leaseTime = this.macHash.get(mac);
                        long now = new Date().getTime() / 1000L;
                        if (leaseTime == null || now <= (long)(leaseTime + TIME_DELTA)) continue;
                        log.debug((Object)"DHCPChecker: deleting record from arp and hash..");
                        log.debug((Object)("DHCPChecker: now(sec)=" + now + " (" + this.showTime(now) + ")"));
                        log.debug((Object)("DHCPChecker: leaseTime(sec)=" + leaseTime + " (until " + this.showTime(leaseTime.intValue()) + ")"));
                        this.macHash.remove(mac);
                        ARPUtil.deleteRecord(ip);
                    }
                    for (Map.Entry<String, Object> entry : this.macHash.entrySet()) {
                        long now = new Date().getTime() / 1000L;
                        String mac = entry.getKey();
                        Integer leaseTime = this.macHash.get(mac);
                        if (leaseTime == null || now <= (long)(leaseTime + TIME_DELTA)) continue;
                        this.macHash.remove(mac);
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private int readInt(BufferedReader reader, byte[] buf) throws IOException {
        return Integer.valueOf(reader.readLine());
    }

    private String showTime(long seconds) {
        Date date = new Date(seconds * 1000L);
        return TimeUtils.format(date, "dd.MM.yyyy HH:mm:ss");
    }
}

