/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.portal.struts.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.WiFiManager;
import ru.bitel.bgbilling.kernel.wifi.common.IpInfo;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.RadiusUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.ScriptUtil;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.common.Utils;

public class ActionAuth
extends Action {
    private static Logger log = Logger.getLogger(ActionAuth.class);

    public ActionForward execute(ActionMapping mapping, ActionForm actionFrom, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String login = request.getParameter("login");
        String passwd = request.getParameter("password");
        GlobalConfig cfg = (GlobalConfig)this.servlet.getServletContext().getAttribute("cfg");
        String realm = cfg.isUseRealm() ? request.getParameter("realm") : null;
        String ip = ServletUtils.getIpFromHeader(request, cfg.getHeaderNameRemoteAddress());
        boolean submitted = request.getParameter("submitted") != null;
        WiFiManager manager = (WiFiManager)this.servlet.getServletContext().getAttribute("manager");
        if (submitted && (manager.isIpAlive(WiFiUtil.getIp(ip), false) || this.checkAuth(login, passwd, ip, realm, request))) {
            String target = (String)request.getSession().getAttribute("originalTarget");
            if (!Utils.isEmptyString(target)) {
                return new ActionForward(target, true);
            }
            request.getSession().removeAttribute("originalTarget");
            return new ActionForward("/", true);
        }
        request.setAttribute("cardLink", (Object)cfg.getCardLink());
        if (cfg.isUseRealm()) {
            request.setAttribute("realms", cfg.getRealms());
        }
        if (cfg.isRemindPassword()) {
            request.setAttribute("remindPassword", (Object)cfg.isRemindPassword());
        }
        if (!Utils.isEmptyString(cfg.getPortalHttpsUrl())) {
            request.setAttribute("securityLink", (Object)cfg.getPortalHttpsUrl());
        }
        if (cfg.isActivate()) {
            request.setAttribute("activateOperation", (Object)"activate");
        } else if (cfg.isActivateWithForward()) {
            request.setAttribute("activateOperation", (Object)"activateWithForward");
        }
        return mapping.findForward("authFailed");
    }

    private boolean checkAuth(String login, String passwd, String ip, String realm, HttpServletRequest request) {
        boolean result;
        block5: {
            RadiusUtil radiusUtil = (RadiusUtil)this.servlet.getServletContext().getAttribute("radiusUtil");
            result = false;
            if (!Utils.isEmptyString(login) && !Utils.isEmptyString(passwd)) {
                try {
                    String acctSessionId = ip + "_" + System.currentTimeMillis();
                    RadiusPacket response = radiusUtil.authUser(login, passwd, ip, realm, acctSessionId);
                    log.info((Object)"checking authentication...");
                    if (response != null && response.getCode() == 2) {
                        log.info((Object)"authentication accepted!!");
                        this.sendWiFiAddSignal(ip, login, passwd, acctSessionId);
                        this.runScript(response, ip);
                        result = true;
                        break block5;
                    }
                    log.info((Object)"authentication rejected!!");
                    this.addAuthErrorToRequest(request, response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String error = "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u0438\u043d \u0438 \u043f\u0430\u0440\u043e\u043b\u044c";
                request.setAttribute("error", (Object)error);
            }
        }
        return result;
    }

    private void runScript(RadiusPacket response, String ip) {
        GlobalConfig cfg = (GlobalConfig)this.servlet.getServletContext().getAttribute("cfg");
        List<Map<String, String>> authAttrs = cfg.getAuthAttrs();
        RadiusUtil radiusUtil = (RadiusUtil)this.servlet.getServletContext().getAttribute("radiusUtil");
        ScriptUtil scriptUtil = (ScriptUtil)this.servlet.getServletContext().getAttribute("scriptUtil");
        ArrayList<String> atrList = new ArrayList<String>();
        try {
            for (Map<String, String> map : authAttrs) {
                Integer vendorCode = Integer.valueOf(map.get("vendorCode"));
                Integer attrCode = Integer.valueOf(map.get("attrCode"));
                String type = map.get("type");
                String param = null;
                if (type.equals("integer")) {
                    Integer value = radiusUtil.getIntAtrrubuteValue(response, vendorCode, attrCode);
                    if (value != null) {
                        param = value.toString();
                    }
                } else if (type.equals("string")) {
                    param = radiusUtil.getStringAtrrubuteValue(response, vendorCode, attrCode);
                }
                if (param == null) {
                    atrList.clear();
                    throw new RuntimeException("Value for vendor code = " + vendorCode + " and attribute code = " + attrCode + " is NULL!!");
                }
                atrList.add(param);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        scriptUtil.runStartScript(ip, atrList);
    }

    private void sendWiFiAddSignal(String ip, String login, String passwd, String acctSessionId) throws IOException {
        WiFiManager manager = (WiFiManager)this.servlet.getServletContext().getAttribute("manager");
        IpInfo info = new IpInfo(WiFiUtil.getIp(ip), new Date().getTime(), login, acctSessionId);
        info.setPasswd(passwd);
        manager.add(info);
    }

    private void addAuthErrorToRequest(HttpServletRequest request, RadiusPacket response) {
        if (response == null) {
            request.setAttribute("error", (Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 - \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443");
            return;
        }
        if (response.getCode() != 2) {
            String error = "";
            int errorCode = Utils.parseInt(response.getStringAttribute(-1, 18, null));
            switch (errorCode) {
                case 1: {
                    error = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d ";
                    break;
                }
                case 2: {
                    error = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c ";
                    break;
                }
                case 12: {
                    error = "\u0423 \u0432\u0430\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0447\u0435\u0442\u0443";
                    break;
                }
                case 44: {
                    error = "\u0414\u043e\u0441\u0442\u0443\u043f \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
                    break;
                }
                case 20: {
                    error = "\u0421\u0442\u0430\u0442\u0443\u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u0437\u0430\u043a\u0440\u044b\u0442/\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                    break;
                }
                default: {
                    error = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 - \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443 [#" + errorCode + "]";
                }
            }
            request.setAttribute("error", (Object)error);
        }
    }
}

