/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class XMLDatabaseSerializer {
    private XMLStreamWriter whereAdd;
    public static final String BINARY_PREFIX = "$BINARY_DATA$";

    protected XMLDatabaseSerializer() {
    }

    public XMLDatabaseSerializer(XMLStreamWriter whereAdd) {
        this.whereAdd = whereAdd;
    }

    public List<String> addItemsFromRS(Connection con, String table, String keyColumn, String keyValue, String retColumn, boolean dateFilter, String date1, String date2, String joins) throws SQLException, XMLStreamException {
        ArrayList<String> result = new ArrayList<String>();
        if (ServerUtils.tableExists(con, table)) {
            StringBuilder query = XMLDatabaseSerializer.addItemFromRsQuery(table, keyColumn, keyValue, dateFilter, date1, date2, joins);
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            this.addItemsFromRS(table, retColumn, result, rs);
            st.close();
        }
        return result;
    }

    public void addItemsFromRS(String table, String retColumn, List<String> result, ResultSet rs) throws SQLException, XMLStreamException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        while (rs.next()) {
            this.startElement(table);
            for (int i = 1; i <= columns; ++i) {
                String name = md.getColumnLabel(i);
                String val = md.getColumnType(i) == -3 ? BINARY_PREFIX + Utils.bytesToString(rs.getBytes(i)) : rs.getString(i);
                if (val == null) continue;
                this.writeAtrtibute(name, val);
                if (retColumn == null || !name.equals(retColumn)) continue;
                result.add(rs.getString(i));
            }
            this.stopElement();
        }
    }

    protected void writeAtrtibute(String name, String val) throws XMLStreamException {
        this.whereAdd.writeAttribute(name, val);
    }

    protected void stopElement() throws XMLStreamException {
        this.whereAdd.writeEndElement();
    }

    protected void startElement(String table) throws XMLStreamException {
        this.whereAdd.writeStartElement(table);
    }

    private static StringBuilder addItemFromRsQuery(String table, String keyColumn, String keyValue, boolean dateFilter, String date1, String date2, String joins) {
        StringBuilder query = new StringBuilder("SELECT " + table + ".* FROM ");
        query.append(table);
        query.append(Utils.maskNull(joins));
        query.append(" WHERE ");
        query.append(keyColumn);
        query.append("='");
        query.append(keyValue);
        query.append("'");
        if (dateFilter && date1 != null && date2 != null) {
            query.append(" AND ( ");
            query.append(date1);
            query.append(" IS NULL OR ");
            query.append(date1);
            query.append("<=CURDATE() ) AND ( ");
            query.append(date2);
            query.append(" IS NULL OR ");
            query.append(date2);
            query.append(">=CURDATE() )");
        }
        return query;
    }

    public static int insertElementToBase(Element el, Connection con) throws SQLException {
        int result = 0;
        String tableName = el.getNodeName();
        if (ServerUtils.tableExists(con, tableName)) {
            StringBuffer query = new StringBuffer("INSERT INTO ");
            query.append(tableName);
            StringBuffer columns = new StringBuffer();
            StringBuffer values = new StringBuffer();
            NamedNodeMap attrs = el.getAttributes();
            int size = attrs.getLength();
            ArrayList<Pair<Boolean, String>> binaryValues = new ArrayList<Pair<Boolean, String>>();
            for (int i = 0; i < size; ++i) {
                Node node = attrs.item(i);
                String col = node.getNodeName();
                String value = node.getNodeValue();
                boolean isBinary = value.startsWith(BINARY_PREFIX);
                if (col.startsWith("_") || tableName.startsWith("npay_service_object_") && col.equals("title")) continue;
                boolean prepared = false;
                if (isBinary) {
                    binaryValues.add(new Pair<Boolean, String>(Boolean.TRUE, value.substring(BINARY_PREFIX.length())));
                    prepared = true;
                } else if (value.contains("'")) {
                    binaryValues.add(new Pair<Boolean, String>(Boolean.FALSE, value));
                    prepared = true;
                }
                columns.append(col);
                columns.append(",");
                if ((col.equals("date1") || col.equals("date2")) && (value.equals("") || value.equals("0000-00-00"))) {
                    values.append("NULL");
                } else if (prepared) {
                    values.append("?");
                } else {
                    values.append("'");
                    values.append(value);
                    values.append("' ");
                }
                values.append(",");
            }
            values.setLength(values.length() - 1);
            columns.setLength(columns.length() - 1);
            query.append(" ( ");
            query.append(columns);
            query.append(" ) ");
            query.append(" VALUES(");
            query.append(values);
            query.append(")");
            PreparedStatement ps = con.prepareStatement(query.toString());
            for (int i = 0; i < binaryValues.size(); ++i) {
                Pair pair = (Pair)binaryValues.get(i);
                if (((Boolean)pair.getFirst()).booleanValue()) {
                    ps.setBytes(i + 1, Utils.hexStringToBytes((String)pair.getSecond()));
                    continue;
                }
                ps.setString(i + 1, (String)pair.getSecond());
            }
            ps.executeUpdate();
            ps.close();
            result = ServerUtils.lastInsertId(con);
        }
        return result;
    }
}

