/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.java2d.Java2DRendererConfigurator;
import org.w3c.dom.Node;

public class FOUtils {
    public static final String RENDER_PDF = "application/pdf";
    public static final String RENDER_RTF = "application/rtf";
    public static final String RENDER_AWT = "application/X-fop-awt-preview";
    public static final String RENDER_PRINT = "application/X-fop-print";
    private static FopFactory fopFactory;

    public static FOUserAgent newFOUserAgent() {
        return fopFactory.newFOUserAgent();
    }

    public static SAXResult renderSAXResult(OutputStream outputStream, String outputFormat) throws FOPException {
        Fop fop = fopFactory.newFop(outputFormat, outputStream);
        return new SAXResult(fop.getDefaultHandler());
    }

    public static SAXResult renderSAXResult(FOUserAgent userAgent, String outputFormat) throws FOPException {
        Fop fop = fopFactory.newFop(outputFormat, userAgent);
        return new SAXResult(fop.getDefaultHandler());
    }

    private static Transformer newTransformer(Source xslt) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(xslt);
        return transformer;
    }

    private static Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        return transformer;
    }

    public static void render(Source xml, Source xslt, OutputStream outputStream, String outputFormat) throws FOPException, TransformerException {
        FOUtils.newTransformer(xslt).transform(xml, FOUtils.renderSAXResult(outputStream, outputFormat));
    }

    public static void render(Source fo, OutputStream outputStream, String outputFormat) throws FOPException, TransformerException {
        FOUtils.newTransformer().transform(fo, FOUtils.renderSAXResult(outputStream, outputFormat));
    }

    public static void render(Source xml, Source xslt, Renderer renderer, String outputFormat) throws FOPException, TransformerException {
        FOUserAgent fua = renderer.getUserAgent() != null ? renderer.getUserAgent() : FOUtils.newFOUserAgent();
        renderer.setUserAgent(fua);
        fua.setRendererOverride(renderer);
        Java2DRendererConfigurator rc = new Java2DRendererConfigurator(fua);
        rc.configure(renderer);
        FOUtils.newTransformer(xslt).transform(xml, FOUtils.renderSAXResult(fua, outputFormat));
    }

    public static void render(Source fo, Renderer renderer, String outputFormat) throws FOPException, TransformerException {
        FOUserAgent fua = renderer.getUserAgent() != null ? renderer.getUserAgent() : FOUtils.newFOUserAgent();
        renderer.setUserAgent(fua);
        fua.setRendererOverride(renderer);
        Java2DRendererConfigurator rc = new Java2DRendererConfigurator(fua);
        rc.configure(renderer);
        FOUtils.newTransformer().transform(fo, FOUtils.renderSAXResult(fua, outputFormat));
    }

    public static void render(Node fo, Renderer renderer, String outputFormat) throws FOPException, TransformerException {
        FOUtils.render((Source)new DOMSource(fo), renderer, outputFormat);
    }

    static {
        block15: {
            fopFactory = null;
            try {
                fopFactory = FopFactory.newInstance();
                try (InputStream in = FOUtils.class.getResourceAsStream("/ru/bitel/common/fop-conf/fop.xconf");){
                    if (in != null) {
                        DefaultConfigurationBuilder dcb = new DefaultConfigurationBuilder();
                        Configuration cfg = dcb.build(in);
                        fopFactory.setUserConfig(cfg);
                        fopFactory.getFontManager().setFontBaseURL("jar:" + FOUtils.class.getResource("/ru/bitel/fonts").getPath());
                        break block15;
                    }
                    throw new RuntimeException("fop config not available");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("fop library initialization error", e);
            }
        }
    }
}

