/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public class PatternStringGenerator {
    public static String insertPatternPart(String srcString, String key, String value) {
        if (srcString != null && key != null) {
            return srcString.replace("${" + key + "}", value != null ? value : "");
        }
        return srcString;
    }

    public static String replacePatternPart(String srcString, String key, String value) {
        StringBuilder result = new StringBuilder(srcString.length());
        Pattern p = Pattern.compile("(([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\s\\[\\]\\(\\)\\\\/#]*)\\$\\{" + key + "\\}([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\s\\[\\]\\(\\)\\\\/#]*))");
        Matcher m = p.matcher(srcString);
        if (m.find()) {
            if (Utils.notBlankString(value)) {
                result.append(srcString.substring(0, m.start()));
                String prefix = m.group(1);
                if (prefix.startsWith(",") && result.length() == 0) {
                    prefix = prefix.substring(1);
                }
                result.append(prefix);
                result.append(value);
                result.append(m.group(2));
                result.append(srcString.substring(m.end()));
            } else {
                result.append(srcString.substring(0, m.start()));
                result.append(srcString.substring(m.end()));
            }
        } else {
            result.append(srcString);
        }
        return result.toString();
    }
}

