/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConcurrentUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean awaitFutures(List<? extends Future<?>> futures, long timeout, TimeUnit unit) throws InterruptedException {
        if (futures == null || unit == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        boolean done = false;
        try {
            long lastTime = System.nanoTime();
            for (Future<?> f : futures) {
                if (f.isDone()) continue;
                if (nanos <= 0L) {
                    boolean bl = done;
                    return bl;
                }
                try {
                    f.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException toe) {
                    boolean bl = done;
                    if (!done) {
                        for (Future<?> f2 : futures) {
                            f2.cancel(true);
                        }
                    }
                    return bl;
                }
                long now = System.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
            boolean bl = done = true;
            return bl;
        }
        finally {
            if (!done) {
                for (Future<?> f : futures) {
                    f.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean awaitFutures(List<? extends Future<?>> futures) throws InterruptedException {
        if (futures == null) {
            throw new NullPointerException();
        }
        boolean done = false;
        try {
            for (Future<?> f : futures) {
                if (f.isDone()) continue;
                try {
                    f.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future<?> f : futures) {
                    f.cancel(true);
                }
            }
        }
        return done;
    }

    public static boolean invokeAll(List<? extends Runnable> tasks, int threadCount) throws InterruptedException {
        ArrayList futures = new ArrayList(tasks.size());
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        for (Runnable runnable : tasks) {
            futures.add(executorService.submit(runnable));
        }
        boolean result = ConcurrentUtils.awaitFutures(futures);
        executorService.shutdown();
        return result;
    }
}

