/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.IOException;
import java.io.OutputStream;
import ru.bitel.common.io.Base64;

public class Base64OutputStream
extends OutputStream {
    private OutputStream outputStream = null;
    private int currentBuffer = 0;
    private int currentBufferCounter = 0;
    private int outputLineCounter = 0;
    private int outputLineMaxlength = 0;

    public Base64OutputStream(OutputStream outputStream) {
        this(outputStream, 76);
    }

    public Base64OutputStream(OutputStream outputStream, int linelength) {
        this.outputStream = outputStream;
        this.outputLineMaxlength = linelength;
    }

    @Override
    public void write(int b2) throws IOException {
        int value = (b2 & 0xFF) << 16 - this.currentBufferCounter * 8;
        this.currentBuffer |= value;
        ++this.currentBufferCounter;
        if (this.currentBufferCounter == 3) {
            this.flushbuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushbuffer();
        this.outputStream.close();
    }

    protected void flushbuffer() throws IOException {
        if (this.currentBufferCounter > 0) {
            if (this.outputLineMaxlength > 0 && this.outputLineCounter == this.outputLineMaxlength) {
                this.outputStream.write("\r\n".getBytes());
                this.outputLineCounter = 0;
            }
            char b1 = Base64.CHARS.charAt(this.currentBuffer << 8 >>> 26);
            char b2 = Base64.CHARS.charAt(this.currentBuffer << 14 >>> 26);
            char b3 = this.currentBufferCounter < 2 ? Base64.PAD : Base64.CHARS.charAt(this.currentBuffer << 20 >>> 26);
            char b4 = this.currentBufferCounter < 3 ? Base64.PAD : Base64.CHARS.charAt(this.currentBuffer << 26 >>> 26);
            this.outputStream.write(b1);
            this.outputStream.write(b2);
            this.outputStream.write(b3);
            this.outputStream.write(b4);
            this.outputLineCounter += 4;
            this.currentBufferCounter = 0;
            this.currentBuffer = 0;
        }
    }
}

