/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FillInputStream
extends InputStream {
    private final Buffer buffer = new Buffer();
    private boolean closed = false;
    protected final OutputStream output = this.buffer;

    @Override
    public int read() throws IOException {
        return this.buffer.read();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        return this.buffer.read(b2, off, len);
    }

    private boolean tryNext() {
        if (this.closed) {
            return false;
        }
        this.buffer.reset();
        int minSize = this.buffer.bufferSize() / 2;
        while (this.buffer.size() < minSize && !this.closed && this.buffer.size() < 8192) {
            this.next();
        }
        return true;
    }

    public abstract void next();

    final class Buffer
    extends ByteArrayOutputStream {
        private int bufferPosition;

        public Buffer() {
            super(256);
            this.bufferPosition = 0;
        }

        public int bufferSize() {
            return this.buf.length;
        }

        public int read() throws IOException {
            if (this.bufferPosition < this.count) {
                return this.buf[this.bufferPosition++];
            }
            if (FillInputStream.this.tryNext()) {
                return this.read();
            }
            return -1;
        }

        public int read(byte[] b2, int off, int len) throws IOException {
            int num = Math.min(this.count - this.bufferPosition, len);
            if (num > 0) {
                System.arraycopy(this.buf, this.bufferPosition, b2, off, num);
                this.bufferPosition += num;
                return num;
            }
            if (FillInputStream.this.tryNext()) {
                return this.read(b2, off, len);
            }
            return -1;
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.bufferPosition = 0;
        }

        @Override
        public void close() throws IOException {
            FillInputStream.this.closed = true;
        }

        @Override
        public synchronized void write(byte[] b2, int off, int len) {
            super.write(b2, off, len);
        }
    }
}

