/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import ru.bitel.common.logging.NestedContext;

public class Log4jAsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    private final List<LoggingEvent> buffer = new ArrayList<LoggingEvent>();
    private final Map<String, DiscardSummary> discardMap = new HashMap<String, DiscardSummary>();
    private int bufferSize = 2048;
    AppenderAttachableImpl aai;
    private final AppenderAttachableImpl appenders = new AppenderAttachableImpl();
    private final Thread dispatcher;
    private boolean locationInfo = false;
    private boolean blocking = true;

    public Log4jAsyncAppender() {
        this.aai = this.appenders;
        this.dispatcher = new Thread(new Dispatcher(this, this.buffer, this.discardMap, this.appenders));
        this.dispatcher.setDaemon(true);
        this.dispatcher.setName("Dispatcher-" + this.dispatcher.getName());
        this.dispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender newAppender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.addAppender(newAppender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (this.dispatcher == null || !this.dispatcher.isAlive() || this.bufferSize <= 0) {
            AppenderAttachableImpl appenderAttachableImpl = this.appenders;
            synchronized (appenderAttachableImpl) {
                this.appenders.appendLoopOnAppenders(event);
            }
            return;
        }
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        String nestedContext = NestedContext.get();
        if (nestedContext != null) {
            event.setProperty("nestedContext", NestedContext.get());
        }
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        List<LoggingEvent> list = this.buffer;
        synchronized (list) {
            String loggerName;
            DiscardSummary summary;
            int previousSize = this.buffer.size();
            if (previousSize < this.bufferSize) {
                this.buffer.add(event);
                if (previousSize == 0) {
                    this.buffer.notifyAll();
                }
                return;
            }
            if (this.blocking) {
                if (!Thread.interrupted() && Thread.currentThread() != this.dispatcher) {
                    try {
                        this.buffer.wait(30L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if ((previousSize = this.buffer.size()) < this.bufferSize) {
                    this.buffer.add(event);
                    if (previousSize == 0) {
                        this.buffer.notifyAll();
                    }
                    return;
                }
            }
            if ((summary = this.discardMap.get(loggerName = event.getLoggerName())) == null) {
                summary = new DiscardSummary(event);
                this.discardMap.put(loggerName, summary);
            } else {
                summary.add(event);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AppenderAttachableImpl appenderAttachableImpl = this.buffer;
        synchronized (appenderAttachableImpl) {
            this.closed = true;
            this.buffer.notifyAll();
        }
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LogLog.error((String)"Got an InterruptedException while waiting for the dispatcher to finish.", (Throwable)e);
        }
        appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            Enumeration iter = this.appenders.getAllAppenders();
            if (iter != null) {
                while (iter.hasMoreElements()) {
                    Object next = iter.nextElement();
                    if (!(next instanceof Appender)) continue;
                    ((Appender)next).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<?> getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAppender(name);
        }
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.isAttached(appender);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(name);
        }
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("size");
        }
        List<LoggingEvent> list = this.buffer;
        synchronized (list) {
            this.bufferSize = size >= 1 ? size : 1;
            this.buffer.notifyAll();
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean value) {
        List<LoggingEvent> list = this.buffer;
        synchronized (list) {
            this.blocking = value;
            this.buffer.notifyAll();
        }
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    private static final class DiscardSummary {
        private LoggingEvent maxEvent;
        private int count;

        public void add(LoggingEvent event) {
            if (event.getLevel().toInt() > this.maxEvent.getLevel().toInt()) {
                this.maxEvent = event;
            }
            ++this.count;
        }

        public LoggingEvent createEvent() {
            String msg = MessageFormat.format("Discarded {0} messages due to full event buffer including: {1}", new Integer(this.count), this.maxEvent.getMessage());
            return new LoggingEvent("org.apache.log4j.AsyncAppender.DONT_REPORT_LOCATION", (Category)Logger.getLogger((String)this.maxEvent.getLoggerName()), (Priority)this.maxEvent.getLevel(), (Object)msg, null);
        }

        public DiscardSummary(LoggingEvent event) {
            this.maxEvent = event;
            this.count = 1;
        }
    }

    private static class Dispatcher
    implements Runnable {
        private final Log4jAsyncAppender parent;
        private final List<LoggingEvent> buffer;
        private final Map<String, DiscardSummary> discardMap;
        private final AppenderAttachableImpl appenders;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isActive = true;
            try {
                while (isActive) {
                    LoggingEvent[] events = null;
                    List<LoggingEvent> list = this.buffer;
                    synchronized (list) {
                        int bufferSize = this.buffer.size();
                        boolean bl = isActive = !this.parent.closed;
                        while (bufferSize == 0 && isActive) {
                            this.buffer.wait();
                            bufferSize = this.buffer.size();
                            isActive = !this.parent.closed;
                        }
                        if (bufferSize > 0) {
                            events = new LoggingEvent[bufferSize + this.discardMap.size()];
                            this.buffer.toArray(events);
                            int index = bufferSize;
                            Iterator<DiscardSummary> iter = this.discardMap.values().iterator();
                            while (iter.hasNext()) {
                                events[index++] = iter.next().createEvent();
                            }
                            this.buffer.clear();
                            this.discardMap.clear();
                            this.buffer.notifyAll();
                        }
                    }
                    if (events == null) continue;
                    for (int i = 0; i < events.length; ++i) {
                        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
                        synchronized (appenderAttachableImpl) {
                            this.appenders.appendLoopOnAppenders(events[i]);
                            continue;
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        public Dispatcher(Log4jAsyncAppender parent, List<LoggingEvent> buffer, Map<String, DiscardSummary> discardMap, AppenderAttachableImpl appenders) {
            this.parent = parent;
            this.buffer = buffer;
            this.appenders = appenders;
            this.discardMap = discardMap;
        }
    }
}

