/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class LoggingPrintWriter
extends PrintWriter {
    private Priority level;
    private Category cat;
    private StringBuilder text = new StringBuilder(300);

    public LoggingPrintWriter(PrintStream def, Category cat, Priority level) {
        super(def);
        this.level = level;
        this.cat = cat;
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.text.length() > 0) {
            this.cat.log(this.level, (Object)this.text.toString());
            this.text.setLength(0);
        }
    }

    @Override
    public void print(boolean b2) {
        this.text.append(b2);
    }

    @Override
    public void print(char c) {
        this.text.append(c);
    }

    @Override
    public void print(char[] s) {
        this.text.append(s);
    }

    @Override
    public void print(double d) {
        this.text.append(d);
    }

    @Override
    public void print(float f) {
        this.text.append(f);
    }

    @Override
    public void print(int i) {
        this.text.append(i);
    }

    @Override
    public void print(long l) {
        this.text.append(l);
    }

    @Override
    public void print(Object obj) {
        this.text.append(obj);
    }

    @Override
    public void print(String s) {
        this.text.append(s);
    }

    @Override
    public void println() {
        if (!this.text.toString().equals("")) {
            this.cat.log(this.level, (Object)this.text.toString());
            this.text.setLength(0);
        }
    }

    @Override
    public void println(boolean x) {
        this.text.append(x);
        this.cat.log(this.level, (Object)this.text.toString());
        this.text.setLength(0);
    }

    @Override
    public void println(char x) {
        this.text.append(x);
        this.cat.log(this.level, (Object)this.text.toString());
        this.text.setLength(0);
    }

    @Override
    public void println(char[] x) {
        this.text.append(x);
        this.cat.log(this.level, (Object)this.text.toString());
        this.text.setLength(0);
    }

    @Override
    public void println(double x) {
        this.text.append(x);
        this.cat.log(this.level, (Object)this.text.toString());
        this.text.setLength(0);
    }

    @Override
    public void println(float x) {
        this.text.append(x);
        this.cat.log(this.level, (Object)this.text.toString());
        this.text.setLength(0);
    }

    @Override
    public void println(int x) {
        this.text.append(x);
        this.cat.log(this.level, (Object)this.text.toString());
        this.text.setLength(0);
    }

    @Override
    public void println(long x) {
        this.text.append(x);
        this.cat.log(this.level, (Object)this.text.toString());
        this.text.setLength(0);
    }

    @Override
    public void println(Object x) {
        this.flush();
        this.cat.log(this.level, (Object)String.valueOf(x));
    }

    @Override
    public void println(String x) {
        this.flush();
        this.cat.log(this.level, (Object)x);
    }
}

