/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.xml.XmlAdapters;

@XmlRootElement
public class PeriodWithTime {
    private LocalDateTime from;
    private LocalDateTime to;

    public PeriodWithTime() {
        this((LocalDateTime)null, (LocalDateTime)null);
    }

    public PeriodWithTime(Date fromDate, Date toDate) {
        this.from = TimeUtils.convertDateToLocalDateTime(fromDate);
        this.to = TimeUtils.convertDateToLocalDateTime(toDate);
    }

    public PeriodWithTime(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        this.from = fromDateTime;
        this.to = toDateTime;
    }

    public Date getDateFrom() {
        return TimeUtils.convertLocalDateTimeToDate(this.from);
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(type=LocalDateTime.class, value=XmlAdapters.LocalDateTimeAdapter.class)
    public LocalDateTime getLocalDateTimeFrom() {
        return this.from;
    }

    public void setLocalDateTimeFrom(LocalDateTime from) {
        this.from = from;
    }

    public Date getDateTo() {
        return TimeUtils.convertLocalDateTimeToDate(this.to);
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(type=LocalDateTime.class, value=XmlAdapters.LocalDateTimeAdapter.class)
    public LocalDateTime getLocalDateTimeTo() {
        return this.to;
    }

    public void setLocalDateTimeTo(LocalDateTime to) {
        this.to = to;
    }

    public String toString() {
        return TimeUtils.formatPeriodWithTime(this.getDateFrom(), this.getDateTo());
    }
}

