/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.server.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SetCharacterEncodingFilter
implements Filter {
    protected String encoding;
    protected FilterConfig filterConfig;
    protected boolean ignore;
    protected static final Logger logger = Logger.getLogger(SetCharacterEncodingFilter.class);

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.ignore || request.getCharacterEncoding() == null) {
            String header = ((HttpServletRequest)request).getHeader("X-Requested-With");
            if (header != null && "XMLHttpRequest".equals(header)) {
                request.setCharacterEncoding("UTF-8");
            } else {
                String encoding = this.selectEncoding(request);
                if (encoding != null) {
                    request.setCharacterEncoding(encoding);
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
        String value = filterConfig.getInitParameter("ignore");
        this.ignore = value == null ? true : (value.equalsIgnoreCase("true") ? true : value.equalsIgnoreCase("yes"));
        logger.debug((Object)("init filter " + filterConfig.getFilterName() + " (encoding=" + this.encoding + ",ignore=" + this.ignore + ")"));
    }

    protected String selectEncoding(ServletRequest request) {
        return this.encoding;
    }
}

