/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class CheckReentrantLock
extends ReentrantLock {
    private static final Logger logger = Logger.getLogger(CheckReentrantLock.class);
    private StackTraceElement[] trace;
    private String name = "";

    protected CheckReentrantLock() {
    }

    public CheckReentrantLock(String name) {
    }

    @Override
    public void lock() {
        try {
            if (!super.tryLock(15L, TimeUnit.SECONDS)) {
                Thread ownerThread = this.getOwner();
                RuntimeException exception = null;
                if (this.trace != null) {
                    exception = new RuntimeException("Trace: " + ownerThread, exception);
                    exception.setStackTrace(this.trace);
                    RuntimeException ex = new RuntimeException();
                    ex.setStackTrace(this.trace);
                    logger.warn((Object)"Object is locked by", (Throwable)ex);
                }
                if (ownerThread != null) {
                    exception = new RuntimeException("OwnerThread: " + ownerThread, exception);
                    exception.setStackTrace(ownerThread.getStackTrace());
                }
                logger.warn((Object)"Lock wait timeout (waiting next 15s)", (Throwable)new RuntimeException("Lock wait timeout for " + this, exception));
                if (!super.tryLock(45L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Lock wait timeout for " + this, exception);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unlock() {
        try {
            if (!super.isHeldByCurrentThread()) {
                logger.error((Object)"Excess unlock", (Throwable)new RuntimeException());
            }
        }
        finally {
            super.unlock();
        }
    }

    public void tryLockEx(long timeout, TimeUnit unit) throws InterruptedException {
        if (!super.tryLock(timeout, unit)) {
            Thread ownerThread = this.getOwner();
            RuntimeException exception = null;
            if (ownerThread != null) {
                exception = new RuntimeException("OwnerThread: " + ownerThread, exception);
                exception.setStackTrace(ownerThread.getStackTrace());
            }
            throw new RuntimeException("Lock wait timeout for " + this, exception);
        }
    }

    @Override
    public String toString() {
        return this.name + "@" + System.identityHashCode(this);
    }
}

