/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.DelayedAdapter;

public class TimeoutListMap<K extends Comparable<K>, V> {
    private static final Logger logger = Logger.getLogger(TimeoutListMap.class);
    private final CopyOnWriteListMap<K, V> map = new CopyOnWriteListMap(64, 2);
    private final DelayQueue<Entry> queue = new DelayQueue();
    private final Runnable worker;

    public TimeoutListMap(ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit unit) {
        this.worker = new Worker();
        scheduledExecutorService.scheduleWithFixedDelay(this.worker, initialDelay, period, unit);
    }

    public TimeoutListMap(BlockingQueue<? extends Map.Entry<K, V>> queue, String workerName) {
        this.worker = new ThreadWorker();
        new Thread(this.worker, workerName).start();
    }

    public void add(K key, V value, long expire) {
        this.map.add(key, value);
        this.queue.add(new Entry(this, key, value, expire));
    }

    public boolean remove(K key, V value) {
        return this.map.remove(key, value);
    }

    public List<V> get(K key) {
        return this.map.get(key);
    }

    public List<V> remove(K key) {
        return this.map.remove(key);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                Entry k;
                DelayQueue queue = TimeoutListMap.this.queue;
                while ((k = (Entry)queue.poll()) != null) {
                    TimeoutListMap.this.map.remove(k.key, k.value);
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
    }

    private class ThreadWorker
    implements Runnable {
        private ThreadWorker() {
        }

        @Override
        public void run() {
            DelayQueue queue = TimeoutListMap.this.queue;
            while (true) {
                try {
                    while (true) {
                        Entry k = (Entry)queue.take();
                        TimeoutListMap.this.map.remove(k.key, k.value);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
    }

    private class Entry
    extends DelayedAdapter {
        final K key;
        final V value;
        final /* synthetic */ TimeoutListMap this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public Entry(K value, V expire, long l2) {
            void key;
            this.this$0 = (TimeoutListMap)l;
            super((long)expire);
            this.key = key;
            this.value = value;
        }
    }
}

